/*!
    \file    gd32l23x_libopt.h
    \brief   library optional for GD32L23x

    \version 2025-08-21, V2.5.0, demo for GD32L23x
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef GD32L23X_LIBOPT_H
#define GD32L23X_LIBOPT_H

#include "gd32l23x_adc.h"
#include "gd32l23x_crc.h"
#include "gd32l23x_cau.h"
#include "gd32l23x_dac.h"
#include "gd32l23x_dbg.h"
#include "gd32l23x_dma.h"
#include "gd32l23x_exti.h"
#include "gd32l23x_fmc.h"
#include "gd32l23x_gpio.h"
#include "gd32l23x_syscfg.h"
#include "gd32l23x_i2c.h"
#include "gd32l23x_fwdgt.h"
#include "gd32l23x_pmu.h"
#include "gd32l23x_rcu.h"
#include "gd32l23x_ctc.h"
#include "gd32l23x_rtc.h"
#include "gd32l23x_spi.h"
#include "gd32l23x_timer.h"
#include "gd32l23x_usart.h"
#include "gd32l23x_lpuart.h"
#include "gd32l23x_wwdgt.h"
#include "gd32l23x_misc.h"
#include "gd32l23x_cmp.h"
#include "gd32l23x_trng.h"
#include "gd32l23x_slcd.h"
#include "gd32l23x_lptimer.h"
#include "gd32l23x_vref.h"
#ifdef GD32L235
#include "gd32l23x_can.h"
#endif /* GD32L235 */

#endif /* GD32L23X_LIBOPT_H */

