/*
 * Copyright (C) 2015-2018 Alibaba Group Holding Limited
 */





#ifndef _SHADOW_IOTX_SHADOW_COMMON_H_
#define _SHADOW_IOTX_SHADOW_COMMON_H_

#include "shadow.h"
#include "shadow_config.h"
#include "utils_list.h"

typedef struct iotx_update_ack_wait_list_st {
    int                 flag_busy; /* 0, free; 1, busy. */
    char                token[IOTX_DS_TOKEN_LEN];
    iotx_push_cb_fpt    callback;
    void               *pcontext;
    iotx_time_t         timer;
} iotx_update_ack_wait_list_t, *iotx_update_ack_wait_list_pt;


typedef struct iotx_inner_data_st {
    uint32_t token_num;
    uint32_t version;
    iotx_shadow_time_t time;
    iotx_update_ack_wait_list_t update_ack_wait_list[IOTX_DS_UPDATE_WAIT_ACK_LIST_NUM];
    list_t *attr_list;
    char *ptopic_update;
    char *ptopic_get;
    int32_t sync_status;
} iotx_inner_data_t, *iotx_inner_data_pt;;


typedef struct iotx_shadow_st {
    void *mqtt;
    void *mutex;
    iotx_inner_data_t inner_data;
} iotx_shadow_t, *iotx_shadow_pt;

iotx_err_t iotx_ds_common_format_init(iotx_shadow_pt pshadow,
                                      format_data_pt pformat,
                                      char *buf,
                                      uint16_t size,
                                      const char *method,
                                      const char *head_str);

iotx_err_t iotx_ds_common_format_add(iotx_shadow_pt pshadow,
                                     format_data_pt pformat,
                                     const char *name,
                                     const void *pvalue,
                                     iotx_shadow_attr_datatype_t datatype);

iotx_err_t iotx_ds_common_format_finalize(iotx_shadow_pt pshadow, format_data_pt pformat, const char *tail_str);

void iotx_ds_common_update_time(iotx_shadow_pt pshadow, uint32_t new_timestamp);

int iotx_ds_common_convert_data2string(
            char *buf,
            size_t buf_len,
            iotx_shadow_attr_datatype_t type,
            const void *pData);

iotx_err_t iotx_ds_common_convert_string2data(
            const char *buf,
            size_t buf_len,
            iotx_shadow_attr_datatype_t type,
            void *pData);

int iotx_ds_common_check_attr_existence(iotx_shadow_pt pshadow, const iotx_shadow_attr_pt pattr);

iotx_err_t iotx_ds_common_register_attr(
            iotx_shadow_pt pshadow,
            iotx_shadow_attr_pt pattr);

iotx_err_t iotx_ds_common_remove_attr(
            iotx_shadow_pt pshadow,
            iotx_shadow_attr_pt pattr);

char *iotx_ds_common_generate_topic_name(iotx_shadow_pt pshadow, const char *topic);

int iotx_ds_common_publish2update(iotx_shadow_pt pshadow, char *data, uint32_t data_len);

void iotx_ds_common_update_version(iotx_shadow_pt pshadow, uint32_t version);

uint32_t iotx_ds_common_get_version(iotx_shadow_pt pshadow);

uint32_t iotx_ds_common_get_tokennum(iotx_shadow_pt pshadow);

#endif /* _SHADOW_IOTX_SHADOW_COMMON_H_ */
