/*
 * Copyright (c) 2001-2019, Arm Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __DX_CRYS_KERNEL_H__
#define __DX_CRYS_KERNEL_H__
// --------------------------------------
// BLOCK: AES
// --------------------------------------
#define DX_AES_KEY_0_0_REG_OFFSET   0x0400UL
#define DX_AES_KEY_0_0_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_KEY_0_0_VALUE_BIT_SIZE   0x20UL
#define DX_AES_KEY_0_1_REG_OFFSET   0x0404UL
#define DX_AES_KEY_0_1_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_KEY_0_1_VALUE_BIT_SIZE   0x20UL
#define DX_AES_KEY_0_2_REG_OFFSET   0x0408UL
#define DX_AES_KEY_0_2_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_KEY_0_2_VALUE_BIT_SIZE   0x20UL
#define DX_AES_KEY_0_3_REG_OFFSET   0x040CUL
#define DX_AES_KEY_0_3_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_KEY_0_3_VALUE_BIT_SIZE   0x20UL
#define DX_AES_KEY_0_4_REG_OFFSET   0x0410UL
#define DX_AES_KEY_0_4_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_KEY_0_4_VALUE_BIT_SIZE   0x20UL
#define DX_AES_KEY_0_5_REG_OFFSET   0x0414UL
#define DX_AES_KEY_0_5_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_KEY_0_5_VALUE_BIT_SIZE   0x20UL
#define DX_AES_KEY_0_6_REG_OFFSET   0x0418UL
#define DX_AES_KEY_0_6_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_KEY_0_6_VALUE_BIT_SIZE   0x20UL
#define DX_AES_KEY_0_7_REG_OFFSET   0x041CUL
#define DX_AES_KEY_0_7_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_KEY_0_7_VALUE_BIT_SIZE   0x20UL
#define DX_AES_KEY_1_0_REG_OFFSET   0x0420UL
#define DX_AES_KEY_1_0_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_KEY_1_0_VALUE_BIT_SIZE   0x20UL
#define DX_AES_KEY_1_1_REG_OFFSET   0x0424UL
#define DX_AES_KEY_1_1_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_KEY_1_1_VALUE_BIT_SIZE   0x20UL
#define DX_AES_KEY_1_2_REG_OFFSET   0x0428UL
#define DX_AES_KEY_1_2_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_KEY_1_2_VALUE_BIT_SIZE   0x20UL
#define DX_AES_KEY_1_3_REG_OFFSET   0x042CUL
#define DX_AES_KEY_1_3_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_KEY_1_3_VALUE_BIT_SIZE   0x20UL
#define DX_AES_KEY_1_4_REG_OFFSET   0x0430UL
#define DX_AES_KEY_1_4_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_KEY_1_4_VALUE_BIT_SIZE   0x20UL
#define DX_AES_KEY_1_5_REG_OFFSET   0x0434UL
#define DX_AES_KEY_1_5_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_KEY_1_5_VALUE_BIT_SIZE   0x20UL
#define DX_AES_KEY_1_6_REG_OFFSET   0x0438UL
#define DX_AES_KEY_1_6_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_KEY_1_6_VALUE_BIT_SIZE   0x20UL
#define DX_AES_KEY_1_7_REG_OFFSET   0x043CUL
#define DX_AES_KEY_1_7_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_KEY_1_7_VALUE_BIT_SIZE   0x20UL
#define DX_AES_IV_0_0_REG_OFFSET    0x0440UL
#define DX_AES_IV_0_0_VALUE_BIT_SHIFT   0x0UL
#define DX_AES_IV_0_0_VALUE_BIT_SIZE    0x20UL
#define DX_AES_IV_0_1_REG_OFFSET    0x0444UL
#define DX_AES_IV_0_1_VALUE_BIT_SHIFT   0x0UL
#define DX_AES_IV_0_1_VALUE_BIT_SIZE    0x20UL
#define DX_AES_IV_0_2_REG_OFFSET    0x0448UL
#define DX_AES_IV_0_2_VALUE_BIT_SHIFT   0x0UL
#define DX_AES_IV_0_2_VALUE_BIT_SIZE    0x20UL
#define DX_AES_IV_0_3_REG_OFFSET    0x044CUL
#define DX_AES_IV_0_3_VALUE_BIT_SHIFT   0x0UL
#define DX_AES_IV_0_3_VALUE_BIT_SIZE    0x20UL
#define DX_AES_IV_1_0_REG_OFFSET    0x0450UL
#define DX_AES_IV_1_0_VALUE_BIT_SHIFT   0x0UL
#define DX_AES_IV_1_0_VALUE_BIT_SIZE    0x20UL
#define DX_AES_IV_1_1_REG_OFFSET    0x0454UL
#define DX_AES_IV_1_1_VALUE_BIT_SHIFT   0x0UL
#define DX_AES_IV_1_1_VALUE_BIT_SIZE    0x20UL
#define DX_AES_IV_1_2_REG_OFFSET    0x0458UL
#define DX_AES_IV_1_2_VALUE_BIT_SHIFT   0x0UL
#define DX_AES_IV_1_2_VALUE_BIT_SIZE    0x20UL
#define DX_AES_IV_1_3_REG_OFFSET    0x045CUL
#define DX_AES_IV_1_3_VALUE_BIT_SHIFT   0x0UL
#define DX_AES_IV_1_3_VALUE_BIT_SIZE    0x20UL
#define DX_AES_CTR_0_0_REG_OFFSET   0x0460UL
#define DX_AES_CTR_0_0_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_CTR_0_0_VALUE_BIT_SIZE   0x20UL
#define DX_AES_CTR_0_1_REG_OFFSET   0x0464UL
#define DX_AES_CTR_0_1_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_CTR_0_1_VALUE_BIT_SIZE   0x20UL
#define DX_AES_CTR_0_2_REG_OFFSET   0x0468UL
#define DX_AES_CTR_0_2_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_CTR_0_2_VALUE_BIT_SIZE   0x20UL
#define DX_AES_CTR_0_3_REG_OFFSET   0x046CUL
#define DX_AES_CTR_0_3_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_CTR_0_3_VALUE_BIT_SIZE   0x20UL
#define DX_AES_BUSY_REG_OFFSET  0x0470UL
#define DX_AES_BUSY_VALUE_BIT_SHIFT     0x0UL
#define DX_AES_BUSY_VALUE_BIT_SIZE  0x1UL
#define DX_AES_SK_REG_OFFSET    0x0478UL
#define DX_AES_SK_VALUE_BIT_SHIFT   0x0UL
#define DX_AES_SK_VALUE_BIT_SIZE    0x1UL
#define DX_AES_CMAC_INIT_REG_OFFSET     0x047CUL
#define DX_AES_CMAC_INIT_VALUE_BIT_SHIFT    0x0UL
#define DX_AES_CMAC_INIT_VALUE_BIT_SIZE     0x1UL
#define DX_AES_SK1_REG_OFFSET   0x04B4UL
#define DX_AES_SK1_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_SK1_VALUE_BIT_SIZE   0x1UL
#define DX_AES_REMAINING_BYTES_REG_OFFSET   0x04BCUL
#define DX_AES_REMAINING_BYTES_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_REMAINING_BYTES_VALUE_BIT_SIZE   0x20UL
#define DX_AES_CONTROL_REG_OFFSET   0x04C0UL
#define DX_AES_CONTROL_DEC_KEY0_BIT_SHIFT   0x0UL
#define DX_AES_CONTROL_DEC_KEY0_BIT_SIZE    0x1UL
#define DX_AES_CONTROL_MODE0_IS_CBC_CTS_BIT_SHIFT   0x1UL
#define DX_AES_CONTROL_MODE0_IS_CBC_CTS_BIT_SIZE    0x1UL
#define DX_AES_CONTROL_MODE_KEY0_BIT_SHIFT  0x2UL
#define DX_AES_CONTROL_MODE_KEY0_BIT_SIZE   0x3UL
#define DX_AES_CONTROL_MODE_KEY1_BIT_SHIFT  0x5UL
#define DX_AES_CONTROL_MODE_KEY1_BIT_SIZE   0x3UL
#define DX_AES_CONTROL_CBC_IS_ESSIV_BIT_SHIFT   0x8UL
#define DX_AES_CONTROL_CBC_IS_ESSIV_BIT_SIZE    0x1UL
#define DX_AES_CONTROL_AES_TUNNEL_IS_ON_BIT_SHIFT   0xAUL
#define DX_AES_CONTROL_AES_TUNNEL_IS_ON_BIT_SIZE    0x1UL
#define DX_AES_CONTROL_CBC_IS_BITLOCKER_BIT_SHIFT   0xBUL
#define DX_AES_CONTROL_CBC_IS_BITLOCKER_BIT_SIZE    0x1UL
#define DX_AES_CONTROL_NK_KEY0_BIT_SHIFT    0xCUL
#define DX_AES_CONTROL_NK_KEY0_BIT_SIZE     0x2UL
#define DX_AES_CONTROL_NK_KEY1_BIT_SHIFT    0xEUL
#define DX_AES_CONTROL_NK_KEY1_BIT_SIZE     0x2UL
#define DX_AES_CONTROL_AES_TUNNEL1_DECRYPT_BIT_SHIFT    0x16UL
#define DX_AES_CONTROL_AES_TUNNEL1_DECRYPT_BIT_SIZE     0x1UL
#define DX_AES_CONTROL_AES_TUN_B1_USES_PADDED_DATA_IN_BIT_SHIFT     0x17UL
#define DX_AES_CONTROL_AES_TUN_B1_USES_PADDED_DATA_IN_BIT_SIZE  0x1UL
#define DX_AES_CONTROL_AES_TUNNEL0_ENCRYPT_BIT_SHIFT    0x18UL
#define DX_AES_CONTROL_AES_TUNNEL0_ENCRYPT_BIT_SIZE     0x1UL
#define DX_AES_CONTROL_AES_OUTPUT_MID_TUNNEL_DATA_BIT_SHIFT     0x19UL
#define DX_AES_CONTROL_AES_OUTPUT_MID_TUNNEL_DATA_BIT_SIZE  0x1UL
#define DX_AES_CONTROL_AES_TUNNEL_B1_PAD_EN_BIT_SHIFT   0x1AUL
#define DX_AES_CONTROL_AES_TUNNEL_B1_PAD_EN_BIT_SIZE    0x1UL
#define DX_AES_CONTROL_AES_OUT_MID_TUN_TO_HASH_BIT_SHIFT    0x1CUL
#define DX_AES_CONTROL_AES_OUT_MID_TUN_TO_HASH_BIT_SIZE     0x1UL
#define DX_AES_CONTROL_AES_XOR_CRYPTOKEY_BIT_SHIFT  0x1DUL
#define DX_AES_CONTROL_AES_XOR_CRYPTOKEY_BIT_SIZE   0x1UL
#define DX_AES_CONTROL_DIRECT_ACCESS_BIT_SHIFT  0x1FUL
#define DX_AES_CONTROL_DIRECT_ACCESS_BIT_SIZE   0x1UL
#define DX_AES_HW_FLAGS_REG_OFFSET  0x04C8UL
#define DX_AES_HW_FLAGS_SUPPORT_256_192_KEY_BIT_SHIFT   0x0UL
#define DX_AES_HW_FLAGS_SUPPORT_256_192_KEY_BIT_SIZE    0x1UL
#define DX_AES_HW_FLAGS_AES_LARGE_RKEK_BIT_SHIFT    0x1UL
#define DX_AES_HW_FLAGS_AES_LARGE_RKEK_BIT_SIZE     0x1UL
#define DX_AES_HW_FLAGS_DPA_CNTRMSR_EXIST_BIT_SHIFT     0x2UL
#define DX_AES_HW_FLAGS_DPA_CNTRMSR_EXIST_BIT_SIZE  0x1UL
#define DX_AES_HW_FLAGS_CTR_EXIST_BIT_SHIFT     0x3UL
#define DX_AES_HW_FLAGS_CTR_EXIST_BIT_SIZE  0x1UL
#define DX_AES_HW_FLAGS_ONLY_ENCRYPT_BIT_SHIFT  0x4UL
#define DX_AES_HW_FLAGS_ONLY_ENCRYPT_BIT_SIZE   0x1UL
#define DX_AES_HW_FLAGS_USE_SBOX_TABLE_BIT_SHIFT    0x5UL
#define DX_AES_HW_FLAGS_USE_SBOX_TABLE_BIT_SIZE     0x1UL
#define DX_AES_HW_FLAGS_USE_5_SBOXES_BIT_SHIFT  0x8UL
#define DX_AES_HW_FLAGS_USE_5_SBOXES_BIT_SIZE   0x1UL
#define DX_AES_HW_FLAGS_AES_SUPPORT_PREV_IV_BIT_SHIFT   0x9UL
#define DX_AES_HW_FLAGS_AES_SUPPORT_PREV_IV_BIT_SIZE    0x1UL
#define DX_AES_HW_FLAGS_AES_TUNNEL_EXISTS_BIT_SHIFT     0xAUL
#define DX_AES_HW_FLAGS_AES_TUNNEL_EXISTS_BIT_SIZE  0x1UL
#define DX_AES_HW_FLAGS_SECOND_REGS_SET_EXIST_BIT_SHIFT     0xBUL
#define DX_AES_HW_FLAGS_SECOND_REGS_SET_EXIST_BIT_SIZE  0x1UL
#define DX_AES_HW_FLAGS_DFA_CNTRMSR_EXIST_BIT_SHIFT     0xCUL
#define DX_AES_HW_FLAGS_DFA_CNTRMSR_EXIST_BIT_SIZE  0x1UL
#define DX_AES_CTR_NO_INCREMENT_REG_OFFSET  0x04D8UL
#define DX_AES_CTR_NO_INCREMENT_VALUE_BIT_SHIFT     0x0UL
#define DX_AES_CTR_NO_INCREMENT_VALUE_BIT_SIZE  0x1UL
#define DX_AES_DFA_IS_ON_REG_OFFSET     0x04F0UL
#define DX_AES_DFA_IS_ON_VALUE_BIT_SHIFT    0x0UL
#define DX_AES_DFA_IS_ON_VALUE_BIT_SIZE     0x1UL
#define DX_AES_DFA_ERR_STATUS_REG_OFFSET    0x04F8UL
#define DX_AES_DFA_ERR_STATUS_VALUE_BIT_SHIFT   0x0UL
#define DX_AES_DFA_ERR_STATUS_VALUE_BIT_SIZE    0x1UL
#define DX_AES_CMAC_SIZE0_KICK_REG_OFFSET   0x0524UL
#define DX_AES_CMAC_SIZE0_KICK_VALUE_BIT_SHIFT  0x0UL
#define DX_AES_CMAC_SIZE0_KICK_VALUE_BIT_SIZE   0x1UL
// --------------------------------------
// BLOCK: MISC
// --------------------------------------
#define DX_AES_CLK_ENABLE_REG_OFFSET    0x0810UL
#define DX_AES_CLK_ENABLE_VALUE_BIT_SHIFT   0x0UL
#define DX_AES_CLK_ENABLE_VALUE_BIT_SIZE    0x1UL
#define DX_HASH_CLK_ENABLE_REG_OFFSET   0x0818UL
#define DX_HASH_CLK_ENABLE_VALUE_BIT_SHIFT  0x0UL
#define DX_HASH_CLK_ENABLE_VALUE_BIT_SIZE   0x1UL
#define DX_PKA_CLK_ENABLE_REG_OFFSET    0x081CUL
#define DX_PKA_CLK_ENABLE_VALUE_BIT_SHIFT   0x0UL
#define DX_PKA_CLK_ENABLE_VALUE_BIT_SIZE    0x1UL
#define DX_DMA_CLK_ENABLE_REG_OFFSET    0x0820UL
#define DX_DMA_CLK_ENABLE_VALUE_BIT_SHIFT   0x0UL
#define DX_DMA_CLK_ENABLE_VALUE_BIT_SIZE    0x1UL
#define DX_CLK_STATUS_REG_OFFSET    0x0824UL
#define DX_CLK_STATUS_AES_CLK_STATUS_BIT_SHIFT  0x0UL
#define DX_CLK_STATUS_AES_CLK_STATUS_BIT_SIZE   0x1UL
#define DX_CLK_STATUS_HASH_CLK_STATUS_BIT_SHIFT     0x2UL
#define DX_CLK_STATUS_HASH_CLK_STATUS_BIT_SIZE  0x1UL
#define DX_CLK_STATUS_PKA_CLK_STATUS_BIT_SHIFT  0x3UL
#define DX_CLK_STATUS_PKA_CLK_STATUS_BIT_SIZE   0x1UL
#define DX_CLK_STATUS_CHACHA_CLK_STATUS_BIT_SHIFT   0x7UL
#define DX_CLK_STATUS_CHACHA_CLK_STATUS_BIT_SIZE    0x1UL
#define DX_CLK_STATUS_DMA_CLK_STATUS_BIT_SHIFT  0x8UL
#define DX_CLK_STATUS_DMA_CLK_STATUS_BIT_SIZE   0x1UL
#define DX_CHACHA_CLK_ENABLE_REG_OFFSET     0x0858UL
#define DX_CHACHA_CLK_ENABLE_VALUE_BIT_SHIFT    0x0UL
#define DX_CHACHA_CLK_ENABLE_VALUE_BIT_SIZE     0x1UL
// --------------------------------------
// BLOCK: CC_CTL
// --------------------------------------
#define DX_CRYPTO_CTL_REG_OFFSET    0x0900UL
#define DX_CRYPTO_CTL_VALUE_BIT_SHIFT   0x0UL
#define DX_CRYPTO_CTL_VALUE_BIT_SIZE    0x5UL
#define DX_CRYPTO_BUSY_REG_OFFSET   0x0910UL
#define DX_CRYPTO_BUSY_VALUE_BIT_SHIFT  0x0UL
#define DX_CRYPTO_BUSY_VALUE_BIT_SIZE   0x1UL
#define DX_HASH_BUSY_REG_OFFSET     0x091CUL
#define DX_HASH_BUSY_VALUE_BIT_SHIFT    0x0UL
#define DX_HASH_BUSY_VALUE_BIT_SIZE     0x1UL
#define DX_CONTEXT_ID_REG_OFFSET    0x0930UL
#define DX_CONTEXT_ID_VALUE_BIT_SHIFT   0x0UL
#define DX_CONTEXT_ID_VALUE_BIT_SIZE    0x8UL
// --------------------------------------
// BLOCK: DIN
// --------------------------------------
#define DX_DIN_BUFFER_REG_OFFSET    0x0C00UL
#define DX_DIN_BUFFER_VALUE_BIT_SHIFT   0x0UL
#define DX_DIN_BUFFER_VALUE_BIT_SIZE    0x20UL
#define DX_DIN_MEM_DMA_BUSY_REG_OFFSET  0x0C20UL
#define DX_DIN_MEM_DMA_BUSY_VALUE_BIT_SHIFT     0x0UL
#define DX_DIN_MEM_DMA_BUSY_VALUE_BIT_SIZE  0x1UL
#define DX_SRC_LLI_WORD0_REG_OFFSET     0x0C28UL
#define DX_SRC_LLI_WORD0_VALUE_BIT_SHIFT    0x0UL
#define DX_SRC_LLI_WORD0_VALUE_BIT_SIZE     0x20UL
#define DX_SRC_LLI_WORD1_REG_OFFSET     0x0C2CUL
#define DX_SRC_LLI_WORD1_BYTES_NUM_BIT_SHIFT    0x0UL
#define DX_SRC_LLI_WORD1_BYTES_NUM_BIT_SIZE     0x1EUL
#define DX_SRC_LLI_WORD1_FIRST_BIT_SHIFT    0x1EUL
#define DX_SRC_LLI_WORD1_FIRST_BIT_SIZE     0x1UL
#define DX_SRC_LLI_WORD1_LAST_BIT_SHIFT     0x1FUL
#define DX_SRC_LLI_WORD1_LAST_BIT_SIZE  0x1UL
#define DX_SRAM_SRC_ADDR_REG_OFFSET     0x0C30UL
#define DX_SRAM_SRC_ADDR_VALUE_BIT_SHIFT    0x0UL
#define DX_SRAM_SRC_ADDR_VALUE_BIT_SIZE     0x20UL
#define DX_DIN_SRAM_BYTES_LEN_REG_OFFSET    0x0C34UL
#define DX_DIN_SRAM_BYTES_LEN_VALUE_BIT_SHIFT   0x0UL
#define DX_DIN_SRAM_BYTES_LEN_VALUE_BIT_SIZE    0x20UL
#define DX_DIN_SRAM_DMA_BUSY_REG_OFFSET     0x0C38UL
#define DX_DIN_SRAM_DMA_BUSY_VALUE_BIT_SHIFT    0x0UL
#define DX_DIN_SRAM_DMA_BUSY_VALUE_BIT_SIZE     0x1UL
#define DX_DIN_SRAM_ENDIANNESS_REG_OFFSET   0x0C3CUL
#define DX_DIN_SRAM_ENDIANNESS_VALUE_BIT_SHIFT  0x0UL
#define DX_DIN_SRAM_ENDIANNESS_VALUE_BIT_SIZE   0x1UL
#define DX_DIN_CPU_DATA_SIZE_REG_OFFSET     0x0C48UL
#define DX_DIN_CPU_DATA_SIZE_VALUE_BIT_SHIFT    0x0UL
#define DX_DIN_CPU_DATA_SIZE_VALUE_BIT_SIZE     0x10UL
#define DX_FIFO_IN_EMPTY_REG_OFFSET     0x0C50UL
#define DX_FIFO_IN_EMPTY_VALUE_BIT_SHIFT    0x0UL
#define DX_FIFO_IN_EMPTY_VALUE_BIT_SIZE     0x1UL
#define DX_DIN_FIFO_RST_PNTR_REG_OFFSET     0x0C58UL
#define DX_DIN_FIFO_RST_PNTR_VALUE_BIT_SHIFT    0x0UL
#define DX_DIN_FIFO_RST_PNTR_VALUE_BIT_SIZE     0x1UL
// --------------------------------------
// BLOCK: DOUT
// --------------------------------------
#define DX_DOUT_BUFFER_REG_OFFSET   0x0D00UL
#define DX_DOUT_BUFFER_VALUE_BIT_SHIFT  0x0UL
#define DX_DOUT_BUFFER_VALUE_BIT_SIZE   0x20UL
#define DX_DOUT_MEM_DMA_BUSY_REG_OFFSET     0x0D20UL
#define DX_DOUT_MEM_DMA_BUSY_VALUE_BIT_SHIFT    0x0UL
#define DX_DOUT_MEM_DMA_BUSY_VALUE_BIT_SIZE     0x1UL
#define DX_DST_LLI_WORD0_REG_OFFSET     0x0D28UL
#define DX_DST_LLI_WORD0_VALUE_BIT_SHIFT    0x0UL
#define DX_DST_LLI_WORD0_VALUE_BIT_SIZE     0x20UL
#define DX_DST_LLI_WORD1_REG_OFFSET     0x0D2CUL
#define DX_DST_LLI_WORD1_BYTES_NUM_BIT_SHIFT    0x0UL
#define DX_DST_LLI_WORD1_BYTES_NUM_BIT_SIZE     0x1EUL
#define DX_DST_LLI_WORD1_FIRST_BIT_SHIFT    0x1EUL
#define DX_DST_LLI_WORD1_FIRST_BIT_SIZE     0x1UL
#define DX_DST_LLI_WORD1_LAST_BIT_SHIFT     0x1FUL
#define DX_DST_LLI_WORD1_LAST_BIT_SIZE  0x1UL
#define DX_SRAM_DEST_ADDR_REG_OFFSET    0x0D30UL
#define DX_SRAM_DEST_ADDR_VALUE_BIT_SHIFT   0x0UL
#define DX_SRAM_DEST_ADDR_VALUE_BIT_SIZE    0x20UL
#define DX_DOUT_SRAM_BYTES_LEN_REG_OFFSET   0x0D34UL
#define DX_DOUT_SRAM_BYTES_LEN_VALUE_BIT_SHIFT  0x0UL
#define DX_DOUT_SRAM_BYTES_LEN_VALUE_BIT_SIZE   0x20UL
#define DX_DOUT_SRAM_DMA_BUSY_REG_OFFSET    0x0D38UL
#define DX_DOUT_SRAM_DMA_BUSY_VALUE_BIT_SHIFT   0x0UL
#define DX_DOUT_SRAM_DMA_BUSY_VALUE_BIT_SIZE    0x1UL
#define DX_DOUT_SRAM_ENDIANNESS_REG_OFFSET  0x0D3CUL
#define DX_DOUT_SRAM_ENDIANNESS_VALUE_BIT_SHIFT     0x0UL
#define DX_DOUT_SRAM_ENDIANNESS_VALUE_BIT_SIZE  0x1UL
#define DX_READ_ALIGN_LAST_REG_OFFSET   0x0D44UL
#define DX_READ_ALIGN_LAST_VALUE_BIT_SHIFT  0x0UL
#define DX_READ_ALIGN_LAST_VALUE_BIT_SIZE   0x1UL
#define DX_DOUT_FIFO_EMPTY_REG_OFFSET   0x0D50UL
#define DX_DOUT_FIFO_EMPTY_VALUE_BIT_SHIFT  0x0UL
#define DX_DOUT_FIFO_EMPTY_VALUE_BIT_SIZE   0x1UL
// --------------------------------------
// BLOCK: HASH
// --------------------------------------
#define DX_HASH_H0_REG_OFFSET   0x0640UL
#define DX_HASH_H0_VALUE_BIT_SHIFT  0x0UL
#define DX_HASH_H0_VALUE_BIT_SIZE   0x20UL
#define DX_HASH_H1_REG_OFFSET   0x0644UL
#define DX_HASH_H1_VALUE_BIT_SHIFT  0x0UL
#define DX_HASH_H1_VALUE_BIT_SIZE   0x20UL
#define DX_HASH_H2_REG_OFFSET   0x0648UL
#define DX_HASH_H2_VALUE_BIT_SHIFT  0x0UL
#define DX_HASH_H2_VALUE_BIT_SIZE   0x20UL
#define DX_HASH_H3_REG_OFFSET   0x064CUL
#define DX_HASH_H3_VALUE_BIT_SHIFT  0x0UL
#define DX_HASH_H3_VALUE_BIT_SIZE   0x20UL
#define DX_HASH_H4_REG_OFFSET   0x0650UL
#define DX_HASH_H4_VALUE_BIT_SHIFT  0x0UL
#define DX_HASH_H4_VALUE_BIT_SIZE   0x20UL
#define DX_HASH_H5_REG_OFFSET   0x0654UL
#define DX_HASH_H5_VALUE_BIT_SHIFT  0x0UL
#define DX_HASH_H5_VALUE_BIT_SIZE   0x20UL
#define DX_HASH_H6_REG_OFFSET   0x0658UL
#define DX_HASH_H6_VALUE_BIT_SHIFT  0x0UL
#define DX_HASH_H6_VALUE_BIT_SIZE   0x20UL
#define DX_HASH_H7_REG_OFFSET   0x065CUL
#define DX_HASH_H7_VALUE_BIT_SHIFT  0x0UL
#define DX_HASH_H7_VALUE_BIT_SIZE   0x20UL
#define DX_HASH_H8_REG_OFFSET   0x0660UL
#define DX_HASH_H8_VALUE_BIT_SHIFT  0x0UL
#define DX_HASH_H8_VALUE_BIT_SIZE   0x20UL
#define DX_AUTO_HW_PADDING_REG_OFFSET   0x0684UL
#define DX_AUTO_HW_PADDING_VALUE_BIT_SHIFT  0x0UL
#define DX_AUTO_HW_PADDING_VALUE_BIT_SIZE   0x1UL
#define DX_HASH_XOR_DIN_REG_OFFSET  0x0688UL
#define DX_HASH_XOR_DIN_VALUE_BIT_SHIFT     0x0UL
#define DX_HASH_XOR_DIN_VALUE_BIT_SIZE  0x20UL
#define DX_LOAD_INIT_STATE_REG_OFFSET   0x0694UL
#define DX_LOAD_INIT_STATE_VALUE_BIT_SHIFT  0x0UL
#define DX_LOAD_INIT_STATE_VALUE_BIT_SIZE   0x1UL
#define DX_HASH_SEL_AES_MAC_REG_OFFSET  0x06A4UL
#define DX_HASH_SEL_AES_MAC_HASH_SEL_AES_MAC_BIT_SHIFT  0x0UL
#define DX_HASH_SEL_AES_MAC_HASH_SEL_AES_MAC_BIT_SIZE   0x1UL
#define DX_HASH_SEL_AES_MAC_GHASH_SEL_BIT_SHIFT     0x1UL
#define DX_HASH_SEL_AES_MAC_GHASH_SEL_BIT_SIZE  0x1UL
#define DX_HASH_VERSION_REG_OFFSET  0x07B0UL
#define DX_HASH_VERSION_FIXES_BIT_SHIFT     0x0UL
#define DX_HASH_VERSION_FIXES_BIT_SIZE  0x8UL
#define DX_HASH_VERSION_MINOR_VERSION_NUMBER_BIT_SHIFT  0x8UL
#define DX_HASH_VERSION_MINOR_VERSION_NUMBER_BIT_SIZE   0x4UL
#define DX_HASH_VERSION_MAJOR_VERSION_NUMBER_BIT_SHIFT  0xCUL
#define DX_HASH_VERSION_MAJOR_VERSION_NUMBER_BIT_SIZE   0x4UL
#define DX_HASH_CONTROL_REG_OFFSET  0x07C0UL
#define DX_HASH_CONTROL_MODE_0_1_BIT_SHIFT  0x0UL
#define DX_HASH_CONTROL_MODE_0_1_BIT_SIZE   0x2UL
#define DX_HASH_CONTROL_MODE_3_BIT_SHIFT    0x3UL
#define DX_HASH_CONTROL_MODE_3_BIT_SIZE     0x1UL
#define DX_HASH_PAD_EN_REG_OFFSET   0x07C4UL
#define DX_HASH_PAD_EN_VALUE_BIT_SHIFT  0x0UL
#define DX_HASH_PAD_EN_VALUE_BIT_SIZE   0x1UL
#define DX_HASH_PAD_CFG_REG_OFFSET  0x07C8UL
#define DX_HASH_PAD_CFG_VALUE_BIT_SHIFT     0x2UL
#define DX_HASH_PAD_CFG_VALUE_BIT_SIZE  0x1UL
#define DX_HASH_CUR_LEN_0_REG_OFFSET    0x07CCUL
#define DX_HASH_CUR_LEN_0_VALUE_BIT_SHIFT   0x0UL
#define DX_HASH_CUR_LEN_0_VALUE_BIT_SIZE    0x20UL
#define DX_HASH_CUR_LEN_1_REG_OFFSET    0x07D0UL
#define DX_HASH_CUR_LEN_1_VALUE_BIT_SHIFT   0x0UL
#define DX_HASH_CUR_LEN_1_VALUE_BIT_SIZE    0x20UL
#define DX_HASH_PARAM_REG_OFFSET    0x07DCUL
#define DX_HASH_PARAM_CW_BIT_SHIFT  0x0UL
#define DX_HASH_PARAM_CW_BIT_SIZE   0x4UL
#define DX_HASH_PARAM_CH_BIT_SHIFT  0x4UL
#define DX_HASH_PARAM_CH_BIT_SIZE   0x4UL
#define DX_HASH_PARAM_DW_BIT_SHIFT  0x8UL
#define DX_HASH_PARAM_DW_BIT_SIZE   0x4UL
#define DX_HASH_PARAM_SHA_512_EXISTS_BIT_SHIFT  0xCUL
#define DX_HASH_PARAM_SHA_512_EXISTS_BIT_SIZE   0x1UL
#define DX_HASH_PARAM_PAD_EXISTS_BIT_SHIFT  0xDUL
#define DX_HASH_PARAM_PAD_EXISTS_BIT_SIZE   0x1UL
#define DX_HASH_PARAM_MD5_EXISTS_BIT_SHIFT  0xEUL
#define DX_HASH_PARAM_MD5_EXISTS_BIT_SIZE   0x1UL
#define DX_HASH_PARAM_HMAC_EXISTS_BIT_SHIFT     0xFUL
#define DX_HASH_PARAM_HMAC_EXISTS_BIT_SIZE  0x1UL
#define DX_HASH_PARAM_SHA_256_EXISTS_BIT_SHIFT  0x10UL
#define DX_HASH_PARAM_SHA_256_EXISTS_BIT_SIZE   0x1UL
#define DX_HASH_PARAM_HASH_COMPARE_EXISTS_BIT_SHIFT     0x11UL
#define DX_HASH_PARAM_HASH_COMPARE_EXISTS_BIT_SIZE  0x1UL
#define DX_HASH_PARAM_DUMP_HASH_TO_DOUT_EXISTS_BIT_SHIFT    0x12UL
#define DX_HASH_PARAM_DUMP_HASH_TO_DOUT_EXISTS_BIT_SIZE     0x1UL
#define DX_HASH_AES_SW_RESET_REG_OFFSET     0x07E4UL
#define DX_HASH_AES_SW_RESET_VALUE_BIT_SHIFT    0x0UL
#define DX_HASH_AES_SW_RESET_VALUE_BIT_SIZE     0x1UL
#define DX_HASH_ENDIANESS_REG_OFFSET    0x07E8UL
#define DX_HASH_ENDIANESS_VALUE_BIT_SHIFT   0x0UL
#define DX_HASH_ENDIANESS_VALUE_BIT_SIZE    0x1UL
// --------------------------------------
// BLOCK: GHASH
// --------------------------------------
#define DX_GHASH_SUBKEY_0_0_REG_OFFSET  0x0960UL
#define DX_GHASH_SUBKEY_0_0_VALUE_BIT_SHIFT     0x0UL
#define DX_GHASH_SUBKEY_0_0_VALUE_BIT_SIZE  0x20UL
#define DX_GHASH_SUBKEY_0_1_REG_OFFSET  0x0964UL
#define DX_GHASH_SUBKEY_0_1_VALUE_BIT_SHIFT     0x0UL
#define DX_GHASH_SUBKEY_0_1_VALUE_BIT_SIZE  0x20UL
#define DX_GHASH_SUBKEY_0_2_REG_OFFSET  0x0968UL
#define DX_GHASH_SUBKEY_0_2_VALUE_BIT_SHIFT     0x0UL
#define DX_GHASH_SUBKEY_0_2_VALUE_BIT_SIZE  0x20UL
#define DX_GHASH_SUBKEY_0_3_REG_OFFSET  0x096CUL
#define DX_GHASH_SUBKEY_0_3_VALUE_BIT_SHIFT     0x0UL
#define DX_GHASH_SUBKEY_0_3_VALUE_BIT_SIZE  0x20UL
#define DX_GHASH_IV_0_0_REG_OFFSET  0x0970UL
#define DX_GHASH_IV_0_0_VALUE_BIT_SHIFT     0x0UL
#define DX_GHASH_IV_0_0_VALUE_BIT_SIZE  0x20UL
#define DX_GHASH_IV_0_1_REG_OFFSET  0x0974UL
#define DX_GHASH_IV_0_1_VALUE_BIT_SHIFT     0x0UL
#define DX_GHASH_IV_0_1_VALUE_BIT_SIZE  0x20UL
#define DX_GHASH_IV_0_2_REG_OFFSET  0x0978UL
#define DX_GHASH_IV_0_2_VALUE_BIT_SHIFT     0x0UL
#define DX_GHASH_IV_0_2_VALUE_BIT_SIZE  0x20UL
#define DX_GHASH_IV_0_3_REG_OFFSET  0x097CUL
#define DX_GHASH_IV_0_3_VALUE_BIT_SHIFT     0x0UL
#define DX_GHASH_IV_0_3_VALUE_BIT_SIZE  0x20UL
#define DX_GHASH_BUSY_REG_OFFSET    0x0980UL
#define DX_GHASH_BUSY_VALUE_BIT_SHIFT   0x0UL
#define DX_GHASH_BUSY_VALUE_BIT_SIZE    0x1UL
#define DX_GHASH_INIT_REG_OFFSET    0x0984UL
#define DX_GHASH_INIT_VALUE_BIT_SHIFT   0x0UL
#define DX_GHASH_INIT_VALUE_BIT_SIZE    0x1UL
// --------------------------------------
// BLOCK: PKA
// --------------------------------------
#define DX_MEMORY_MAP0_REG_OFFSET   0x0000UL
#define DX_MEMORY_MAP0_VALUE_BIT_SHIFT  0x1UL
#define DX_MEMORY_MAP0_VALUE_BIT_SIZE   0xAUL
#define DX_MEMORY_MAP1_REG_OFFSET   0x0004UL
#define DX_MEMORY_MAP1_VALUE_BIT_SHIFT  0x1UL
#define DX_MEMORY_MAP1_VALUE_BIT_SIZE   0xAUL
#define DX_MEMORY_MAP2_REG_OFFSET   0x0008UL
#define DX_MEMORY_MAP2_VALUE_BIT_SHIFT  0x1UL
#define DX_MEMORY_MAP2_VALUE_BIT_SIZE   0xAUL
#define DX_MEMORY_MAP3_REG_OFFSET   0x000CUL
#define DX_MEMORY_MAP3_VALUE_BIT_SHIFT  0x1UL
#define DX_MEMORY_MAP3_VALUE_BIT_SIZE   0xAUL
#define DX_MEMORY_MAP4_REG_OFFSET   0x0010UL
#define DX_MEMORY_MAP4_VALUE_BIT_SHIFT  0x1UL
#define DX_MEMORY_MAP4_VALUE_BIT_SIZE   0xAUL
#define DX_MEMORY_MAP5_REG_OFFSET   0x0014UL
#define DX_MEMORY_MAP5_VALUE_BIT_SHIFT  0x1UL
#define DX_MEMORY_MAP5_VALUE_BIT_SIZE   0xAUL
#define DX_MEMORY_MAP6_REG_OFFSET   0x0018UL
#define DX_MEMORY_MAP6_VALUE_BIT_SHIFT  0x1UL
#define DX_MEMORY_MAP6_VALUE_BIT_SIZE   0xAUL
#define DX_MEMORY_MAP7_REG_OFFSET   0x001CUL
#define DX_MEMORY_MAP7_VALUE_BIT_SHIFT  0x1UL
#define DX_MEMORY_MAP7_VALUE_BIT_SIZE   0xAUL
#define DX_MEMORY_MAP8_REG_OFFSET   0x0020UL
#define DX_MEMORY_MAP8_VALUE_BIT_SHIFT  0x1UL
#define DX_MEMORY_MAP8_VALUE_BIT_SIZE   0xAUL
#define DX_MEMORY_MAP9_REG_OFFSET   0x0024UL
#define DX_MEMORY_MAP9_VALUE_BIT_SHIFT  0x1UL
#define DX_MEMORY_MAP9_VALUE_BIT_SIZE   0xAUL
#define DX_MEMORY_MAP10_REG_OFFSET  0x0028UL
#define DX_MEMORY_MAP10_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP10_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP11_REG_OFFSET  0x002CUL
#define DX_MEMORY_MAP11_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP11_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP12_REG_OFFSET  0x0030UL
#define DX_MEMORY_MAP12_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP12_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP13_REG_OFFSET  0x0034UL
#define DX_MEMORY_MAP13_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP13_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP14_REG_OFFSET  0x0038UL
#define DX_MEMORY_MAP14_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP14_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP15_REG_OFFSET  0x003CUL
#define DX_MEMORY_MAP15_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP15_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP16_REG_OFFSET  0x0040UL
#define DX_MEMORY_MAP16_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP16_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP17_REG_OFFSET  0x0044UL
#define DX_MEMORY_MAP17_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP17_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP18_REG_OFFSET  0x0048UL
#define DX_MEMORY_MAP18_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP18_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP19_REG_OFFSET  0x004CUL
#define DX_MEMORY_MAP19_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP19_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP20_REG_OFFSET  0x0050UL
#define DX_MEMORY_MAP20_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP20_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP21_REG_OFFSET  0x0054UL
#define DX_MEMORY_MAP21_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP21_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP22_REG_OFFSET  0x0058UL
#define DX_MEMORY_MAP22_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP22_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP23_REG_OFFSET  0x005CUL
#define DX_MEMORY_MAP23_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP23_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP24_REG_OFFSET  0x0060UL
#define DX_MEMORY_MAP24_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP24_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP25_REG_OFFSET  0x0064UL
#define DX_MEMORY_MAP25_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP25_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP26_REG_OFFSET  0x0068UL
#define DX_MEMORY_MAP26_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP26_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP27_REG_OFFSET  0x006CUL
#define DX_MEMORY_MAP27_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP27_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP28_REG_OFFSET  0x0070UL
#define DX_MEMORY_MAP28_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP28_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP29_REG_OFFSET  0x0074UL
#define DX_MEMORY_MAP29_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP29_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP30_REG_OFFSET  0x0078UL
#define DX_MEMORY_MAP30_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP30_VALUE_BIT_SIZE  0xAUL
#define DX_MEMORY_MAP31_REG_OFFSET  0x007CUL
#define DX_MEMORY_MAP31_VALUE_BIT_SHIFT     0x1UL
#define DX_MEMORY_MAP31_VALUE_BIT_SIZE  0xAUL
#define DX_OPCODE_REG_OFFSET    0x0080UL
#define DX_OPCODE_TAG_BIT_SHIFT     0x0UL
#define DX_OPCODE_TAG_BIT_SIZE  0x6UL
#define DX_OPCODE_REG_R_BIT_SHIFT   0x6UL
#define DX_OPCODE_REG_R_BIT_SIZE    0x6UL
#define DX_OPCODE_REG_B_BIT_SHIFT   0xCUL
#define DX_OPCODE_REG_B_BIT_SIZE    0x6UL
#define DX_OPCODE_REG_A_BIT_SHIFT   0x12UL
#define DX_OPCODE_REG_A_BIT_SIZE    0x6UL
#define DX_OPCODE_LEN_BIT_SHIFT     0x18UL
#define DX_OPCODE_LEN_BIT_SIZE  0x3UL
#define DX_OPCODE_OPCODE_BIT_SHIFT  0x1BUL
#define DX_OPCODE_OPCODE_BIT_SIZE   0x5UL
#define DX_N_NP_T0_T1_ADDR_REG_OFFSET   0x0084UL
#define DX_N_NP_T0_T1_ADDR_N_VIRTUAL_ADDR_BIT_SHIFT     0x0UL
#define DX_N_NP_T0_T1_ADDR_N_VIRTUAL_ADDR_BIT_SIZE  0x5UL
#define DX_N_NP_T0_T1_ADDR_NP_VIRTUAL_ADDR_BIT_SHIFT    0x5UL
#define DX_N_NP_T0_T1_ADDR_NP_VIRTUAL_ADDR_BIT_SIZE     0x5UL
#define DX_N_NP_T0_T1_ADDR_T0_VIRTUAL_ADDR_BIT_SHIFT    0xAUL
#define DX_N_NP_T0_T1_ADDR_T0_VIRTUAL_ADDR_BIT_SIZE     0x5UL
#define DX_N_NP_T0_T1_ADDR_T1_VIRTUAL_ADDR_BIT_SHIFT    0xFUL
#define DX_N_NP_T0_T1_ADDR_T1_VIRTUAL_ADDR_BIT_SIZE     0x5UL
#define DX_PKA_STATUS_REG_OFFSET    0x0088UL
#define DX_PKA_STATUS_ALU_MSB_4BITS_BIT_SHIFT   0x0UL
#define DX_PKA_STATUS_ALU_MSB_4BITS_BIT_SIZE    0x4UL
#define DX_PKA_STATUS_ALU_LSB_4BITS_BIT_SHIFT   0x4UL
#define DX_PKA_STATUS_ALU_LSB_4BITS_BIT_SIZE    0x4UL
#define DX_PKA_STATUS_ALU_SIGN_OUT_BIT_SHIFT    0x8UL
#define DX_PKA_STATUS_ALU_SIGN_OUT_BIT_SIZE     0x1UL
#define DX_PKA_STATUS_ALU_CARRY_BIT_SHIFT   0x9UL
#define DX_PKA_STATUS_ALU_CARRY_BIT_SIZE    0x1UL
#define DX_PKA_STATUS_ALU_CARRY_MOD_BIT_SHIFT   0xAUL
#define DX_PKA_STATUS_ALU_CARRY_MOD_BIT_SIZE    0x1UL
#define DX_PKA_STATUS_ALU_SUB_IS_ZERO_BIT_SHIFT     0xBUL
#define DX_PKA_STATUS_ALU_SUB_IS_ZERO_BIT_SIZE  0x1UL
#define DX_PKA_STATUS_ALU_OUT_ZERO_BIT_SHIFT    0xCUL
#define DX_PKA_STATUS_ALU_OUT_ZERO_BIT_SIZE     0x1UL
#define DX_PKA_STATUS_ALU_MODOVRFLW_BIT_SHIFT   0xDUL
#define DX_PKA_STATUS_ALU_MODOVRFLW_BIT_SIZE    0x1UL
#define DX_PKA_STATUS_DIV_BY_ZERO_BIT_SHIFT     0xEUL
#define DX_PKA_STATUS_DIV_BY_ZERO_BIT_SIZE  0x1UL
#define DX_PKA_STATUS_MODINV_OF_ZERO_BIT_SHIFT  0xFUL
#define DX_PKA_STATUS_MODINV_OF_ZERO_BIT_SIZE   0x1UL
#define DX_PKA_STATUS_OPCODE_BIT_SHIFT  0x10UL
#define DX_PKA_STATUS_OPCODE_BIT_SIZE   0x5UL
#define DX_PKA_SW_RESET_REG_OFFSET  0x008CUL
#define DX_PKA_SW_RESET_VALUE_BIT_SHIFT     0x0UL
#define DX_PKA_SW_RESET_VALUE_BIT_SIZE  0x1UL
#define DX_PKA_L0_REG_OFFSET    0x0090UL
#define DX_PKA_L0_VALUE_BIT_SHIFT   0x0UL
#define DX_PKA_L0_VALUE_BIT_SIZE    0xDUL
#define DX_PKA_L1_REG_OFFSET    0x0094UL
#define DX_PKA_L1_VALUE_BIT_SHIFT   0x0UL
#define DX_PKA_L1_VALUE_BIT_SIZE    0xDUL
#define DX_PKA_L2_REG_OFFSET    0x0098UL
#define DX_PKA_L2_VALUE_BIT_SHIFT   0x0UL
#define DX_PKA_L2_VALUE_BIT_SIZE    0xDUL
#define DX_PKA_L3_REG_OFFSET    0x009CUL
#define DX_PKA_L3_VALUE_BIT_SHIFT   0x0UL
#define DX_PKA_L3_VALUE_BIT_SIZE    0xDUL
#define DX_PKA_L4_REG_OFFSET    0x00A0UL
#define DX_PKA_L4_VALUE_BIT_SHIFT   0x0UL
#define DX_PKA_L4_VALUE_BIT_SIZE    0xDUL
#define DX_PKA_L5_REG_OFFSET    0x00A4UL
#define DX_PKA_L5_VALUE_BIT_SHIFT   0x0UL
#define DX_PKA_L5_VALUE_BIT_SIZE    0xDUL
#define DX_PKA_L6_REG_OFFSET    0x00A8UL
#define DX_PKA_L6_VALUE_BIT_SHIFT   0x0UL
#define DX_PKA_L6_VALUE_BIT_SIZE    0xDUL
#define DX_PKA_L7_REG_OFFSET    0x00ACUL
#define DX_PKA_L7_VALUE_BIT_SHIFT   0x0UL
#define DX_PKA_L7_VALUE_BIT_SIZE    0xDUL
#define DX_PKA_PIPE_RDY_REG_OFFSET  0x00B0UL
#define DX_PKA_PIPE_RDY_VALUE_BIT_SHIFT     0x0UL
#define DX_PKA_PIPE_RDY_VALUE_BIT_SIZE  0x1UL
#define DX_PKA_DONE_REG_OFFSET  0x00B4UL
#define DX_PKA_DONE_VALUE_BIT_SHIFT     0x0UL
#define DX_PKA_DONE_VALUE_BIT_SIZE  0x1UL
#define DX_PKA_MON_SELECT_REG_OFFSET    0x00B8UL
#define DX_PKA_MON_SELECT_VALUE_BIT_SHIFT   0x0UL
#define DX_PKA_MON_SELECT_VALUE_BIT_SIZE    0x4UL
#define DX_PKA_VERSION_REG_OFFSET   0x00C4UL
#define DX_PKA_VERSION_VALUE_BIT_SHIFT  0x0UL
#define DX_PKA_VERSION_VALUE_BIT_SIZE   0x20UL
#define DX_PKA_MON_READ_REG_OFFSET  0x00D0UL
#define DX_PKA_MON_READ_VALUE_BIT_SHIFT     0x0UL
#define DX_PKA_MON_READ_VALUE_BIT_SIZE  0x20UL
#define DX_PKA_SRAM_ADDR_REG_OFFSET     0x00D4UL
#define DX_PKA_SRAM_ADDR_VALUE_BIT_SHIFT    0x0UL
#define DX_PKA_SRAM_ADDR_VALUE_BIT_SIZE     0x20UL
#define DX_PKA_SRAM_WDATA_REG_OFFSET    0x00D8UL
#define DX_PKA_SRAM_WDATA_VALUE_BIT_SHIFT   0x0UL
#define DX_PKA_SRAM_WDATA_VALUE_BIT_SIZE    0x20UL
#define DX_PKA_SRAM_RDATA_REG_OFFSET    0x00DCUL
#define DX_PKA_SRAM_RDATA_VALUE_BIT_SHIFT   0x0UL
#define DX_PKA_SRAM_RDATA_VALUE_BIT_SIZE    0x20UL
#define DX_PKA_SRAM_WR_CLR_REG_OFFSET   0x00E0UL
#define DX_PKA_SRAM_WR_CLR_VALUE_BIT_SHIFT  0x0UL
#define DX_PKA_SRAM_WR_CLR_VALUE_BIT_SIZE   0x20UL
#define DX_PKA_SRAM_RADDR_REG_OFFSET    0x00E4UL
#define DX_PKA_SRAM_RADDR_VALUE_BIT_SHIFT   0x0UL
#define DX_PKA_SRAM_RADDR_VALUE_BIT_SIZE    0x20UL
#define DX_PKA_WORD_ACCESS_REG_OFFSET   0x00F0UL
#define DX_PKA_WORD_ACCESS_VALUE_BIT_SHIFT  0x0UL
#define DX_PKA_WORD_ACCESS_VALUE_BIT_SIZE   0x20UL
#define DX_PKA_BUFF_ADDR_REG_OFFSET     0x00F8UL
#define DX_PKA_BUFF_ADDR_PKA_BUF_ADDR_BIT_SHIFT     0x0UL
#define DX_PKA_BUFF_ADDR_PKA_BUF_ADDR_BIT_SIZE  0xCUL
#define DX_PKA_BUFF_ADDR_RESEREVED1_BIT_SHIFT   0xCUL
#define DX_PKA_BUFF_ADDR_RESEREVED1_BIT_SIZE    0x14UL
// --------------------------------------
// BLOCK: AHB
// --------------------------------------
#define DX_AHBM_SINGLES_REG_OFFSET  0x0B00UL
#define DX_AHBM_SINGLES_VALUE_BIT_SHIFT     0x0UL
#define DX_AHBM_SINGLES_VALUE_BIT_SIZE  0x1UL
#define DX_AHBM_HPROT_REG_OFFSET    0x0B04UL
#define DX_AHBM_HPROT_VALUE_BIT_SHIFT   0x0UL
#define DX_AHBM_HPROT_VALUE_BIT_SIZE    0x4UL
#define DX_AHBM_HMASTLOCK_REG_OFFSET    0x0B08UL
#define DX_AHBM_HMASTLOCK_VALUE_BIT_SHIFT   0x0UL
#define DX_AHBM_HMASTLOCK_VALUE_BIT_SIZE    0x1UL
#define DX_AHBM_HNONSEC_REG_OFFSET  0x0B0CUL
#define DX_AHBM_HNONSEC_AHB_WRITE_HNONSEC_BIT_SHIFT     0x0UL
#define DX_AHBM_HNONSEC_AHB_WRITE_HNONSEC_BIT_SIZE  0x1UL
#define DX_AHBM_HNONSEC_AHB_READ_HNONSEC_BIT_SHIFT  0x1UL
#define DX_AHBM_HNONSEC_AHB_READ_HNONSEC_BIT_SIZE   0x1UL
// --------------------------------------
// BLOCK: AO
// --------------------------------------
#define DX_HOST_DCU_EN0_REG_OFFSET  0x1E00UL
#define DX_HOST_DCU_EN0_VALUE_BIT_SHIFT     0x0UL
#define DX_HOST_DCU_EN0_VALUE_BIT_SIZE  0x20UL
#define DX_HOST_DCU_EN1_REG_OFFSET  0x1E04UL
#define DX_HOST_DCU_EN1_VALUE_BIT_SHIFT     0x0UL
#define DX_HOST_DCU_EN1_VALUE_BIT_SIZE  0x20UL
#define DX_HOST_DCU_EN2_REG_OFFSET  0x1E08UL
#define DX_HOST_DCU_EN2_VALUE_BIT_SHIFT     0x0UL
#define DX_HOST_DCU_EN2_VALUE_BIT_SIZE  0x20UL
#define DX_HOST_DCU_EN3_REG_OFFSET  0x1E0CUL
#define DX_HOST_DCU_EN3_VALUE_BIT_SHIFT     0x0UL
#define DX_HOST_DCU_EN3_VALUE_BIT_SIZE  0x20UL
#define DX_HOST_DCU_LOCK0_REG_OFFSET    0x1E10UL
#define DX_HOST_DCU_LOCK0_VALUE_BIT_SHIFT   0x0UL
#define DX_HOST_DCU_LOCK0_VALUE_BIT_SIZE    0x20UL
#define DX_HOST_DCU_LOCK1_REG_OFFSET    0x1E14UL
#define DX_HOST_DCU_LOCK1_VALUE_BIT_SHIFT   0x0UL
#define DX_HOST_DCU_LOCK1_VALUE_BIT_SIZE    0x20UL
#define DX_HOST_DCU_LOCK2_REG_OFFSET    0x1E18UL
#define DX_HOST_DCU_LOCK2_VALUE_BIT_SHIFT   0x0UL
#define DX_HOST_DCU_LOCK2_VALUE_BIT_SIZE    0x20UL
#define DX_HOST_DCU_LOCK3_REG_OFFSET    0x1E1CUL
#define DX_HOST_DCU_LOCK3_VALUE_BIT_SHIFT   0x0UL
#define DX_HOST_DCU_LOCK3_VALUE_BIT_SIZE    0x20UL
#define DX_AO_ICV_DCU_RESTRICTION_MASK0_REG_OFFSET  0x1E20UL
#define DX_AO_ICV_DCU_RESTRICTION_MASK0_VALUE_BIT_SHIFT     0x0UL
#define DX_AO_ICV_DCU_RESTRICTION_MASK0_VALUE_BIT_SIZE  0x20UL
#define DX_AO_ICV_DCU_RESTRICTION_MASK1_REG_OFFSET  0x1E24UL
#define DX_AO_ICV_DCU_RESTRICTION_MASK1_VALUE_BIT_SHIFT     0x0UL
#define DX_AO_ICV_DCU_RESTRICTION_MASK1_VALUE_BIT_SIZE  0x20UL
#define DX_AO_ICV_DCU_RESTRICTION_MASK2_REG_OFFSET  0x1E28UL
#define DX_AO_ICV_DCU_RESTRICTION_MASK2_VALUE_BIT_SHIFT     0x0UL
#define DX_AO_ICV_DCU_RESTRICTION_MASK2_VALUE_BIT_SIZE  0x20UL
#define DX_AO_ICV_DCU_RESTRICTION_MASK3_REG_OFFSET  0x1E2CUL
#define DX_AO_ICV_DCU_RESTRICTION_MASK3_VALUE_BIT_SHIFT     0x0UL
#define DX_AO_ICV_DCU_RESTRICTION_MASK3_VALUE_BIT_SIZE  0x20UL
#define DX_AO_CC_SEC_DEBUG_RESET_REG_OFFSET     0x1E30UL
#define DX_AO_CC_SEC_DEBUG_RESET_VALUE_BIT_SHIFT    0x0UL
#define DX_AO_CC_SEC_DEBUG_RESET_VALUE_BIT_SIZE     0x1UL
#define DX_HOST_AO_LOCK_BITS_REG_OFFSET     0x1E34UL
#define DX_HOST_AO_LOCK_BITS_HOST_FATAL_ERR_BIT_SHIFT   0x0UL
#define DX_HOST_AO_LOCK_BITS_HOST_FATAL_ERR_BIT_SIZE    0x1UL
#define DX_HOST_AO_LOCK_BITS_HOST_KPICV_LOCK_BIT_SHIFT  0x1UL
#define DX_HOST_AO_LOCK_BITS_HOST_KPICV_LOCK_BIT_SIZE   0x1UL
#define DX_HOST_AO_LOCK_BITS_HOST_KCEICV_LOCK_BIT_SHIFT     0x2UL
#define DX_HOST_AO_LOCK_BITS_HOST_KCEICV_LOCK_BIT_SIZE  0x1UL
#define DX_HOST_AO_LOCK_BITS_HOST_KCP_LOCK_BIT_SHIFT    0x3UL
#define DX_HOST_AO_LOCK_BITS_HOST_KCP_LOCK_BIT_SIZE     0x1UL
#define DX_HOST_AO_LOCK_BITS_HOST_KCE_LOCK_BIT_SHIFT    0x4UL
#define DX_HOST_AO_LOCK_BITS_HOST_KCE_LOCK_BIT_SIZE     0x1UL
#define DX_HOST_AO_LOCK_BITS_HOST_ICV_RMA_LOCK_BIT_SHIFT    0x5UL
#define DX_HOST_AO_LOCK_BITS_HOST_ICV_RMA_LOCK_BIT_SIZE     0x1UL
#define DX_HOST_AO_LOCK_BITS_RESET_UPON_DEBUG_DISABLE_BIT_SHIFT     0x6UL
#define DX_HOST_AO_LOCK_BITS_RESET_UPON_DEBUG_DISABLE_BIT_SIZE  0x1UL
#define DX_HOST_AO_LOCK_BITS_HOST_FORCE_DFA_ENABLE_BIT_SHIFT    0x7UL
#define DX_HOST_AO_LOCK_BITS_HOST_FORCE_DFA_ENABLE_BIT_SIZE     0x1UL
#define DX_HOST_AO_LOCK_BITS_HOST_DFA_ENABLE_LOCK_BIT_SHIFT     0x8UL
#define DX_HOST_AO_LOCK_BITS_HOST_DFA_ENABLE_LOCK_BIT_SIZE  0x1UL
#define DX_AO_APB_FILTERING_REG_OFFSET  0x1E38UL
#define DX_AO_APB_FILTERING_ONLY_SEC_ACCESS_ALLOW_BIT_SHIFT     0x0UL
#define DX_AO_APB_FILTERING_ONLY_SEC_ACCESS_ALLOW_BIT_SIZE  0x1UL
#define DX_AO_APB_FILTERING_ONLY_SEC_ACCESS_ALLOW_LOCK_BIT_SHIFT    0x1UL
#define DX_AO_APB_FILTERING_ONLY_SEC_ACCESS_ALLOW_LOCK_BIT_SIZE     0x1UL
#define DX_AO_APB_FILTERING_ONLY_PRIV_ACCESS_ALLOW_BIT_SHIFT    0x2UL
#define DX_AO_APB_FILTERING_ONLY_PRIV_ACCESS_ALLOW_BIT_SIZE     0x1UL
#define DX_AO_APB_FILTERING_ONLY_PRIV_ACCESS_ALLOW_LOCK_BIT_SHIFT   0x3UL
#define DX_AO_APB_FILTERING_ONLY_PRIV_ACCESS_ALLOW_LOCK_BIT_SIZE    0x1UL
#define DX_AO_APB_FILTERING_APBC_ONLY_SEC_ACCESS_ALLOW_BIT_SHIFT    0x4UL
#define DX_AO_APB_FILTERING_APBC_ONLY_SEC_ACCESS_ALLOW_BIT_SIZE     0x1UL
#define DX_AO_APB_FILTERING_APBC_ONLY_SEC_ACCESS_ALLOW_LOCK_BIT_SHIFT   0x5UL
#define DX_AO_APB_FILTERING_APBC_ONLY_SEC_ACCESS_ALLOW_LOCK_BIT_SIZE    0x1UL
#define DX_AO_APB_FILTERING_APBC_ONLY_PRIV_ACCESS_ALLOW_BIT_SHIFT   0x6UL
#define DX_AO_APB_FILTERING_APBC_ONLY_PRIV_ACCESS_ALLOW_BIT_SIZE    0x1UL
#define DX_AO_APB_FILTERING_APBC_ONLY_PRIV_ACCESS_ALLOW_LOCK_BIT_SHIFT  0x7UL
#define DX_AO_APB_FILTERING_APBC_ONLY_PRIV_ACCESS_ALLOW_LOCK_BIT_SIZE   0x1UL
#define DX_AO_APB_FILTERING_APBC_ONLY_INST_ACCESS_ALLOW_BIT_SHIFT   0x8UL
#define DX_AO_APB_FILTERING_APBC_ONLY_INST_ACCESS_ALLOW_BIT_SIZE    0x1UL
#define DX_AO_APB_FILTERING_APBC_ONLY_INST_ACCESS_ALLOW_LOCK_BIT_SHIFT  0x9UL
#define DX_AO_APB_FILTERING_APBC_ONLY_INST_ACCESS_ALLOW_LOCK_BIT_SIZE   0x1UL
#define DX_AO_CC_GPPC_REG_OFFSET    0x1E3CUL
#define DX_AO_CC_GPPC_VALUE_BIT_SHIFT   0x0UL
#define DX_AO_CC_GPPC_VALUE_BIT_SIZE    0x8UL
#define DX_HOST_RGF_CC_SW_RST_REG_OFFSET    0x1E40UL
#define DX_HOST_RGF_CC_SW_RST_VALUE_BIT_SHIFT   0x0UL
#define DX_HOST_RGF_CC_SW_RST_VALUE_BIT_SIZE    0x1UL
// --------------------------------------
// BLOCK: CHACHA
// --------------------------------------
#define DX_CHACHA_CONTROL_REG_REG_OFFSET    0x0380UL
#define DX_CHACHA_CONTROL_REG_CHACHA_OR_SALSA_BIT_SHIFT     0x0UL
#define DX_CHACHA_CONTROL_REG_CHACHA_OR_SALSA_BIT_SIZE  0x1UL
#define DX_CHACHA_CONTROL_REG_INIT_FROM_HOST_BIT_SHIFT  0x1UL
#define DX_CHACHA_CONTROL_REG_INIT_FROM_HOST_BIT_SIZE   0x1UL
#define DX_CHACHA_CONTROL_REG_CALC_KEY_FOR_POLY1305_BIT_SHIFT   0x2UL
#define DX_CHACHA_CONTROL_REG_CALC_KEY_FOR_POLY1305_BIT_SIZE    0x1UL
#define DX_CHACHA_CONTROL_REG_KEY_LEN_BIT_SHIFT     0x3UL
#define DX_CHACHA_CONTROL_REG_KEY_LEN_BIT_SIZE  0x1UL
#define DX_CHACHA_CONTROL_REG_NUM_OF_ROUNDS_BIT_SHIFT   0x4UL
#define DX_CHACHA_CONTROL_REG_NUM_OF_ROUNDS_BIT_SIZE    0x2UL
#define DX_CHACHA_CONTROL_REG_RESET_BLOCK_CNT_BIT_SHIFT     0x9UL
#define DX_CHACHA_CONTROL_REG_RESET_BLOCK_CNT_BIT_SIZE  0x1UL
#define DX_CHACHA_CONTROL_REG_USE_IV_96BIT_BIT_SHIFT    0xAUL
#define DX_CHACHA_CONTROL_REG_USE_IV_96BIT_BIT_SIZE     0x1UL
#define DX_CHACHA_VERSION_REG_OFFSET    0x0384UL
#define DX_CHACHA_VERSION_VALUE_BIT_SHIFT   0x0UL
#define DX_CHACHA_VERSION_VALUE_BIT_SIZE    0x20UL
#define DX_CHACHA_KEY0_REG_OFFSET   0x0388UL
#define DX_CHACHA_KEY0_VALUE_BIT_SHIFT  0x0UL
#define DX_CHACHA_KEY0_VALUE_BIT_SIZE   0x20UL
#define DX_CHACHA_KEY1_REG_OFFSET   0x038CUL
#define DX_CHACHA_KEY1_VALUE_BIT_SHIFT  0x0UL
#define DX_CHACHA_KEY1_VALUE_BIT_SIZE   0x20UL
#define DX_CHACHA_KEY2_REG_OFFSET   0x0390UL
#define DX_CHACHA_KEY2_VALUE_BIT_SHIFT  0x0UL
#define DX_CHACHA_KEY2_VALUE_BIT_SIZE   0x20UL
#define DX_CHACHA_KEY3_REG_OFFSET   0x0394UL
#define DX_CHACHA_KEY3_VALUE_BIT_SHIFT  0x0UL
#define DX_CHACHA_KEY3_VALUE_BIT_SIZE   0x20UL
#define DX_CHACHA_KEY4_REG_OFFSET   0x0398UL
#define DX_CHACHA_KEY4_VALUE_BIT_SHIFT  0x0UL
#define DX_CHACHA_KEY4_VALUE_BIT_SIZE   0x20UL
#define DX_CHACHA_KEY5_REG_OFFSET   0x039CUL
#define DX_CHACHA_KEY5_VALUE_BIT_SHIFT  0x0UL
#define DX_CHACHA_KEY5_VALUE_BIT_SIZE   0x20UL
#define DX_CHACHA_KEY6_REG_OFFSET   0x03A0UL
#define DX_CHACHA_KEY6_VALUE_BIT_SHIFT  0x0UL
#define DX_CHACHA_KEY6_VALUE_BIT_SIZE   0x20UL
#define DX_CHACHA_KEY7_REG_OFFSET   0x03A4UL
#define DX_CHACHA_KEY7_VALUE_BIT_SHIFT  0x0UL
#define DX_CHACHA_KEY7_VALUE_BIT_SIZE   0x20UL
#define DX_CHACHA_IV_0_REG_OFFSET   0x03A8UL
#define DX_CHACHA_IV_0_VALUE_BIT_SHIFT  0x0UL
#define DX_CHACHA_IV_0_VALUE_BIT_SIZE   0x20UL
#define DX_CHACHA_IV_1_REG_OFFSET   0x03ACUL
#define DX_CHACHA_IV_1_VALUE_BIT_SHIFT  0x0UL
#define DX_CHACHA_IV_1_VALUE_BIT_SIZE   0x20UL
#define DX_CHACHA_BUSY_REG_OFFSET   0x03B0UL
#define DX_CHACHA_BUSY_VALUE_BIT_SHIFT  0x0UL
#define DX_CHACHA_BUSY_VALUE_BIT_SIZE   0x1UL
#define DX_CHACHA_HW_FLAGS_REG_OFFSET   0x03B4UL
#define DX_CHACHA_HW_FLAGS_CHACHA_EXISTS_BIT_SHIFT  0x0UL
#define DX_CHACHA_HW_FLAGS_CHACHA_EXISTS_BIT_SIZE   0x1UL
#define DX_CHACHA_HW_FLAGS_SALSA_EXISTS_BIT_SHIFT   0x1UL
#define DX_CHACHA_HW_FLAGS_SALSA_EXISTS_BIT_SIZE    0x1UL
#define DX_CHACHA_HW_FLAGS_FAST_CHACHA_BIT_SHIFT    0x2UL
#define DX_CHACHA_HW_FLAGS_FAST_CHACHA_BIT_SIZE     0x1UL
#define DX_CHACHA_BLOCK_CNT_LSB_REG_OFFSET  0x03B8UL
#define DX_CHACHA_BLOCK_CNT_LSB_VALUE_BIT_SHIFT     0x0UL
#define DX_CHACHA_BLOCK_CNT_LSB_VALUE_BIT_SIZE  0x20UL
#define DX_CHACHA_BLOCK_CNT_MSB_REG_OFFSET  0x03BCUL
#define DX_CHACHA_BLOCK_CNT_MSB_VALUE_BIT_SHIFT     0x0UL
#define DX_CHACHA_BLOCK_CNT_MSB_VALUE_BIT_SIZE  0x20UL
#define DX_CHACHA_SW_RESET_REG_OFFSET   0x03C0UL
#define DX_CHACHA_SW_RESET_VALUE_BIT_SHIFT  0x0UL
#define DX_CHACHA_SW_RESET_VALUE_BIT_SIZE   0x1UL
#define DX_CHACHA_FOR_POLY_KEY0_REG_OFFSET  0x03C4UL
#define DX_CHACHA_FOR_POLY_KEY0_VALUE_BIT_SHIFT     0x0UL
#define DX_CHACHA_FOR_POLY_KEY0_VALUE_BIT_SIZE  0x20UL
#define DX_CHACHA_FOR_POLY_KEY1_REG_OFFSET  0x03C8UL
#define DX_CHACHA_FOR_POLY_KEY1_VALUE_BIT_SHIFT     0x0UL
#define DX_CHACHA_FOR_POLY_KEY1_VALUE_BIT_SIZE  0x20UL
#define DX_CHACHA_FOR_POLY_KEY2_REG_OFFSET  0x03CCUL
#define DX_CHACHA_FOR_POLY_KEY2_VALUE_BIT_SHIFT     0x0UL
#define DX_CHACHA_FOR_POLY_KEY2_VALUE_BIT_SIZE  0x20UL
#define DX_CHACHA_FOR_POLY_KEY3_REG_OFFSET  0x03D0UL
#define DX_CHACHA_FOR_POLY_KEY3_VALUE_BIT_SHIFT     0x0UL
#define DX_CHACHA_FOR_POLY_KEY3_VALUE_BIT_SIZE  0x20UL
#define DX_CHACHA_FOR_POLY_KEY4_REG_OFFSET  0x03D4UL
#define DX_CHACHA_FOR_POLY_KEY4_VALUE_BIT_SHIFT     0x0UL
#define DX_CHACHA_FOR_POLY_KEY4_VALUE_BIT_SIZE  0x20UL
#define DX_CHACHA_FOR_POLY_KEY5_REG_OFFSET  0x03D8UL
#define DX_CHACHA_FOR_POLY_KEY5_VALUE_BIT_SHIFT     0x0UL
#define DX_CHACHA_FOR_POLY_KEY5_VALUE_BIT_SIZE  0x20UL
#define DX_CHACHA_FOR_POLY_KEY6_REG_OFFSET  0x03DCUL
#define DX_CHACHA_FOR_POLY_KEY6_VALUE_BIT_SHIFT     0x0UL
#define DX_CHACHA_FOR_POLY_KEY6_VALUE_BIT_SIZE  0x20UL
#define DX_CHACHA_FOR_POLY_KEY7_REG_OFFSET  0x03E0UL
#define DX_CHACHA_FOR_POLY_KEY7_VALUE_BIT_SHIFT     0x0UL
#define DX_CHACHA_FOR_POLY_KEY7_VALUE_BIT_SIZE  0x20UL
#define DX_CHACHA_BYTE_WORD_ORDER_CNTL_REG_REG_OFFSET   0x03E4UL
#define DX_CHACHA_BYTE_WORD_ORDER_CNTL_REG_CHACHA_DIN_WORD_ORDER_BIT_SHIFT  0x0UL
#define DX_CHACHA_BYTE_WORD_ORDER_CNTL_REG_CHACHA_DIN_WORD_ORDER_BIT_SIZE   0x1UL
#define DX_CHACHA_BYTE_WORD_ORDER_CNTL_REG_CHACHA_DIN_BYTE_ORDER_BIT_SHIFT  0x1UL
#define DX_CHACHA_BYTE_WORD_ORDER_CNTL_REG_CHACHA_DIN_BYTE_ORDER_BIT_SIZE   0x1UL
#define DX_CHACHA_BYTE_WORD_ORDER_CNTL_REG_CHACHA_CORE_MATRIX_LBE_ORDER_BIT_SHIFT   0x2UL
#define DX_CHACHA_BYTE_WORD_ORDER_CNTL_REG_CHACHA_CORE_MATRIX_LBE_ORDER_BIT_SIZE    0x1UL
#define DX_CHACHA_BYTE_WORD_ORDER_CNTL_REG_CHACHA_DOUT_WORD_ORDER_BIT_SHIFT     0x3UL
#define DX_CHACHA_BYTE_WORD_ORDER_CNTL_REG_CHACHA_DOUT_WORD_ORDER_BIT_SIZE  0x1UL
#define DX_CHACHA_BYTE_WORD_ORDER_CNTL_REG_CHACHA_DOUT_BYTE_ORDER_BIT_SHIFT     0x4UL
#define DX_CHACHA_BYTE_WORD_ORDER_CNTL_REG_CHACHA_DOUT_BYTE_ORDER_BIT_SIZE  0x1UL
#define DX_CHACHA_DEBUG_REG_REG_OFFSET  0x03E8UL
#define DX_CHACHA_DEBUG_REG_VALUE_BIT_SHIFT     0x0UL
#define DX_CHACHA_DEBUG_REG_VALUE_BIT_SIZE  0x2UL

#endif  // __DX_CRYS_KERNEL_H__
