/*
 * Copyright (c) 2019, Cypress Semiconductor Corporation. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __DRIVER_PPU_H__
#define __DRIVER_PPU_H__

#include "cy_prot.h"
#include "RTE_Device.h"

/* PSoC 6 has 6 different kinds of PPU */
enum ppu_type {
    MS_PPU_PR,
    MS_PPU_FX,
    PPU_PR,
    PPU_GR,
    GR_PPU_SL,
    GR_PPU_RG,
    NO_PPU
};

typedef struct ppu_resources PPU_Resources;

/* Shared Driver wrapper functions */
cy_en_prot_status_t PPU_Configure(const PPU_Resources *ppu_dev);

/* Per-PPU macros */
#define DECLARE_MS_PPU_PR(N) extern const PPU_Resources N##_PPU_Resources;
#define DECLARE_MS_PPU_FX(N) extern const PPU_Resources N##_PPU_Resources;
#define DECLARE_PPU_PR(N) extern const PPU_Resources N##_PPU_Resources;
#define DECLARE_PPU_GR(N) extern const PPU_Resources N##_PPU_Resources;
#define DECLARE_GR_PPU_SL(N) extern const PPU_Resources N##_PPU_Resources;
#define DECLARE_GR_PPU_RG(N) extern const PPU_Resources N##_PPU_Resources;

#if (RTE_MS_PPU_PR7)
DECLARE_MS_PPU_PR(PR7)
#endif

#if (RTE_MS_PPU_PERI_MAIN)
DECLARE_MS_PPU_FX(PERI_MAIN)
#endif

#if (RTE_MS_PPU_PERI_GR0_GROUP)
DECLARE_MS_PPU_FX(PERI_GR0_GROUP)
#endif

#if (RTE_MS_PPU_PERI_GR1_GROUP)
DECLARE_MS_PPU_FX(PERI_GR1_GROUP)
#endif

#if (RTE_MS_PPU_PERI_GR2_GROUP)
DECLARE_MS_PPU_FX(PERI_GR2_GROUP)
#endif

#if (RTE_MS_PPU_PERI_GR3_GROUP)
DECLARE_MS_PPU_FX(PERI_GR3_GROUP)
#endif

#if (RTE_MS_PPU_PERI_GR4_GROUP)
DECLARE_MS_PPU_FX(PERI_GR4_GROUP)
#endif

#if (RTE_MS_PPU_PERI_GR6_GROUP)
DECLARE_MS_PPU_FX(PERI_GR6_GROUP)
#endif

#if (RTE_MS_PPU_PERI_GR9_GROUP)
DECLARE_MS_PPU_FX(PERI_GR9_GROUP)
#endif

#if (RTE_MS_PPU_PERI_GR10_GROUP)
DECLARE_MS_PPU_FX(PERI_GR10_GROUP)
#endif

#if (RTE_MS_PPU_PERI_TR)
DECLARE_MS_PPU_FX(PERI_TR)
#endif

#if (RTE_MS_PPU_CRYPTO_MAIN)
DECLARE_MS_PPU_FX(CRYPTO_MAIN)
#endif

#if (RTE_MS_PPU_CRYPTO_CRYPTO)
DECLARE_MS_PPU_FX(CRYPTO_CRYPTO)
#endif

#if (RTE_MS_PPU_CRYPTO_BOOT)
DECLARE_MS_PPU_FX(CRYPTO_BOOT)
#endif

#if (RTE_MS_PPU_CRYPTO_KEY0)
DECLARE_MS_PPU_FX(CRYPTO_KEY0)
#endif

#if (RTE_MS_PPU_CRYPTO_KEY1)
DECLARE_MS_PPU_FX(CRYPTO_KEY1)
#endif

#if (RTE_MS_PPU_CRYPTO_BUF)
DECLARE_MS_PPU_FX(CRYPTO_BUF)
#endif

#if (RTE_MS_PPU_CPUSS_CM4)
DECLARE_MS_PPU_FX(CPUSS_CM4)
#endif

#if (RTE_MS_PPU_CPUSS_CM0)
DECLARE_MS_PPU_FX(CPUSS_CM0)
#endif

#if (RTE_MS_PPU_CPUSS_CM0_INT)
DECLARE_MS_PPU_FX(CPUSS_CM0_INT)
#endif

#if (RTE_MS_PPU_CPUSS_CM4_INT)
DECLARE_MS_PPU_FX(CPUSS_CM4_INT)
#endif

#if (RTE_MS_PPU_FAULT_STRUCT0_MAIN)
DECLARE_MS_PPU_FX(FAULT_STRUCT0_MAIN)
#endif

#if (RTE_MS_PPU_FAULT_STRUCT1_MAIN)
DECLARE_MS_PPU_FX(FAULT_STRUCT1_MAIN)
#endif

#if (RTE_MS_PPU_IPC_STRUCT0_IPC)
DECLARE_MS_PPU_FX(IPC_STRUCT0_IPC)
#endif

#if (RTE_MS_PPU_IPC_STRUCT1_IPC)
DECLARE_MS_PPU_FX(IPC_STRUCT1_IPC)
#endif

#if (RTE_MS_PPU_IPC_STRUCT2_IPC)
DECLARE_MS_PPU_FX(IPC_STRUCT2_IPC)
#endif

#if (RTE_MS_PPU_IPC_STRUCT3_IPC)
DECLARE_MS_PPU_FX(IPC_STRUCT3_IPC)
#endif

#if (RTE_MS_PPU_IPC_STRUCT4_IPC)
DECLARE_MS_PPU_FX(IPC_STRUCT4_IPC)
#endif

#if (RTE_MS_PPU_IPC_STRUCT5_IPC)
DECLARE_MS_PPU_FX(IPC_STRUCT5_IPC)
#endif

#if (RTE_MS_PPU_IPC_STRUCT6_IPC)
DECLARE_MS_PPU_FX(IPC_STRUCT6_IPC)
#endif

#if (RTE_MS_PPU_IPC_STRUCT7_IPC)
DECLARE_MS_PPU_FX(IPC_STRUCT7_IPC)
#endif

#if (RTE_MS_PPU_IPC_STRUCT8_IPC)
DECLARE_MS_PPU_FX(IPC_STRUCT8_IPC)
#endif

#if (RTE_MS_PPU_IPC_STRUCT9_IPC)
DECLARE_MS_PPU_FX(IPC_STRUCT9_IPC)
#endif

#if (RTE_MS_PPU_IPC_STRUCT10_IPC)
DECLARE_MS_PPU_FX(IPC_STRUCT10_IPC)
#endif

#if (RTE_MS_PPU_IPC_STRUCT11_IPC)
DECLARE_MS_PPU_FX(IPC_STRUCT11_IPC)
#endif

#if (RTE_MS_PPU_IPC_STRUCT12_IPC)
DECLARE_MS_PPU_FX(IPC_STRUCT12_IPC)
#endif

#if (RTE_MS_PPU_IPC_STRUCT13_IPC)
DECLARE_MS_PPU_FX(IPC_STRUCT13_IPC)
#endif

#if (RTE_MS_PPU_IPC_STRUCT14_IPC)
DECLARE_MS_PPU_FX(IPC_STRUCT14_IPC)
#endif

#if (RTE_MS_PPU_IPC_STRUCT15_IPC)
DECLARE_MS_PPU_FX(IPC_STRUCT15_IPC)
#endif

#if (RTE_MS_PPU_IPC_INTR_STRUCT1_INTR)
DECLARE_MS_PPU_FX(IPC_INTR_STRUCT1_INTR)
#endif

#if (RTE_MS_PPU_IPC_INTR_STRUCT2_INTR)
DECLARE_MS_PPU_FX(IPC_INTR_STRUCT2_INTR)
#endif

#if (RTE_MS_PPU_IPC_INTR_STRUCT3_INTR)
DECLARE_MS_PPU_FX(IPC_INTR_STRUCT3_INTR)
#endif

#if (RTE_MS_PPU_IPC_INTR_STRUCT4_INTR)
DECLARE_MS_PPU_FX(IPC_INTR_STRUCT4_INTR)
#endif

#if (RTE_MS_PPU_IPC_INTR_STRUCT5_INTR)
DECLARE_MS_PPU_FX(IPC_INTR_STRUCT5_INTR)
#endif

#if (RTE_MS_PPU_IPC_INTR_STRUCT6_INTR)
DECLARE_MS_PPU_FX(IPC_INTR_STRUCT6_INTR)
#endif

#if (RTE_MS_PPU_IPC_INTR_STRUCT7_INTR)
DECLARE_MS_PPU_FX(IPC_INTR_STRUCT7_INTR)
#endif

#if (RTE_MS_PPU_IPC_INTR_STRUCT8_INTR)
DECLARE_MS_PPU_FX(IPC_INTR_STRUCT8_INTR)
#endif

#if (RTE_MS_PPU_IPC_INTR_STRUCT9_INTR)
DECLARE_MS_PPU_FX(IPC_INTR_STRUCT9_INTR)
#endif

#if (RTE_MS_PPU_IPC_INTR_STRUCT10_INTR)
DECLARE_MS_PPU_FX(IPC_INTR_STRUCT10_INTR)
#endif

#if (RTE_MS_PPU_IPC_INTR_STRUCT11_INTR)
DECLARE_MS_PPU_FX(IPC_INTR_STRUCT11_INTR)
#endif

#if (RTE_MS_PPU_IPC_INTR_STRUCT12_INTR)
DECLARE_MS_PPU_FX(IPC_INTR_STRUCT12_INTR)
#endif

#if (RTE_MS_PPU_IPC_INTR_STRUCT13_INTR)
DECLARE_MS_PPU_FX(IPC_INTR_STRUCT13_INTR)
#endif

#if (RTE_MS_PPU_IPC_INTR_STRUCT14_INTR)
DECLARE_MS_PPU_FX(IPC_INTR_STRUCT14_INTR)
#endif

#if (RTE_MS_PPU_IPC_INTR_STRUCT15_INTR)
DECLARE_MS_PPU_FX(IPC_INTR_STRUCT15_INTR)
#endif

#if (RTE_MS_PPU_PROT_SMPU_MAIN)
DECLARE_MS_PPU_FX(PROT_SMPU_MAIN)
#endif

#if (RTE_MS_PPU_PROT_MPU0_MAIN)
DECLARE_MS_PPU_FX(PROT_MPU0_MAIN)
#endif

#if (RTE_MS_PPU_PROT_MPU5_MAIN)
DECLARE_MS_PPU_FX(PROT_MPU5_MAIN)
#endif

#if (RTE_MS_PPU_PROT_MPU6_MAIN)
DECLARE_MS_PPU_FX(PROT_MPU6_MAIN)
#endif

#if (RTE_MS_PPU_PROT_MPU14_MAIN)
DECLARE_MS_PPU_FX(PROT_MPU14_MAIN)
#endif

#if (RTE_MS_PPU_FLASHC_MAIN)
DECLARE_MS_PPU_FX(FLASHC_MAIN)
#endif

#if (RTE_MS_PPU_FLASHC_CMD)
DECLARE_MS_PPU_FX(FLASHC_CMD)
#endif

#if (RTE_MS_PPU_SRSS_MAIN1)
DECLARE_MS_PPU_FX(SRSS_MAIN1)
#endif

#if (RTE_MS_PPU_SRSS_MAIN2)
DECLARE_MS_PPU_FX(SRSS_MAIN2)
#endif

#if (RTE_MS_PPU_WDT)
DECLARE_MS_PPU_FX(WDT)
#endif

#if (RTE_MS_PPU_MAIN)
DECLARE_MS_PPU_FX(MAIN)
#endif

#if (RTE_MS_PPU_SRSS_MAIN3)
DECLARE_MS_PPU_FX(SRSS_MAIN3)
#endif

#if (RTE_MS_PPU_SRSS_MAIN4)
DECLARE_MS_PPU_FX(SRSS_MAIN4)
#endif

#if (RTE_MS_PPU_SRSS_MAIN5)
DECLARE_MS_PPU_FX(SRSS_MAIN5)
#endif

#if (RTE_MS_PPU_SRSS_MAIN6)
DECLARE_MS_PPU_FX(SRSS_MAIN6)
#endif

#if (RTE_MS_PPU_SRSS_MAIN7)
DECLARE_MS_PPU_FX(SRSS_MAIN7)
#endif

#if (RTE_MS_PPU_BACKUP_BACKUP)
DECLARE_MS_PPU_FX(BACKUP_BACKUP)
#endif

#if (RTE_MS_PPU_DW0_DW)
DECLARE_MS_PPU_FX(DW0_DW)
#endif

#if (RTE_MS_PPU_DW1_DW)
DECLARE_MS_PPU_FX(DW1_DW)
#endif

#if (RTE_MS_PPU_DW0_DW_CRC)
DECLARE_MS_PPU_FX(DW0_DW_CRC)
#endif

#if (RTE_MS_PPU_DW1_DW_CRC)
DECLARE_MS_PPU_FX(DW1_DW_CRC)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT0_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT0_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT1_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT1_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT2_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT2_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT3_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT3_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT4_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT4_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT5_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT5_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT6_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT6_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT7_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT7_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT8_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT8_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT9_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT9_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT10_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT10_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT11_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT11_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT12_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT12_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT13_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT13_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT14_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT14_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT15_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT15_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT16_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT16_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT17_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT17_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT18_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT18_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT19_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT19_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT20_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT20_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT21_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT21_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT22_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT22_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT23_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT23_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT24_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT24_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT25_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT25_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT26_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT26_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT27_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT27_CH)
#endif

#if (RTE_MS_PPU_DW0_CH_STRUCT28_CH)
DECLARE_MS_PPU_FX(DW0_CH_STRUCT28_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT0_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT0_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT1_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT1_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT2_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT2_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT3_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT3_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT4_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT4_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT5_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT5_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT6_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT6_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT7_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT7_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT8_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT8_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT9_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT9_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT10_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT10_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT11_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT11_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT12_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT12_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT13_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT13_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT14_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT14_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT15_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT15_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT16_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT16_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT17_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT17_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT18_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT18_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT19_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT19_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT20_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT20_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT21_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT21_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT22_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT22_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT23_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT23_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT24_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT24_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT25_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT25_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT26_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT26_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT27_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT27_CH)
#endif

#if (RTE_MS_PPU_DW1_CH_STRUCT28_CH)
DECLARE_MS_PPU_FX(DW1_CH_STRUCT28_CH)
#endif

#if (RTE_MS_PPU_DMAC_TOP)
DECLARE_MS_PPU_FX(DMAC_TOP)
#endif

#if (RTE_MS_PPU_DMAC_CH0_CH)
DECLARE_MS_PPU_FX(DMAC_CH0_CH)
#endif

#if (RTE_MS_PPU_DMAC_CH1_CH)
DECLARE_MS_PPU_FX(DMAC_CH1_CH)
#endif

#if (RTE_MS_PPU_DMAC_CH2_CH)
DECLARE_MS_PPU_FX(DMAC_CH2_CH)
#endif

#if (RTE_MS_PPU_DMAC_CH3_CH)
DECLARE_MS_PPU_FX(DMAC_CH3_CH)
#endif

#if (RTE_MS_PPU_EFUSE_DATA)
DECLARE_MS_PPU_FX(EFUSE_DATA)
#endif

#if (RTE_MS_PPU_PROFILE)
DECLARE_MS_PPU_FX(PROFILE)
#endif

#if (RTE_MS_PPU_HSIOM_PRT0_PRT)
DECLARE_MS_PPU_FX(HSIOM_PRT0_PRT)
#endif

#if (RTE_MS_PPU_HSIOM_PRT1_PRT)
DECLARE_MS_PPU_FX(HSIOM_PRT1_PRT)
#endif

#if (RTE_MS_PPU_HSIOM_PRT2_PRT)
DECLARE_MS_PPU_FX(HSIOM_PRT2_PRT)
#endif

#if (RTE_MS_PPU_HSIOM_PRT3_PRT)
DECLARE_MS_PPU_FX(HSIOM_PRT3_PRT)
#endif

#if (RTE_MS_PPU_HSIOM_PRT4_PRT)
DECLARE_MS_PPU_FX(HSIOM_PRT4_PRT)
#endif

#if (RTE_MS_PPU_HSIOM_PRT5_PRT)
DECLARE_MS_PPU_FX(HSIOM_PRT5_PRT)
#endif

#if (RTE_MS_PPU_HSIOM_PRT6_PRT)
DECLARE_MS_PPU_FX(HSIOM_PRT6_PRT)
#endif

#if (RTE_MS_PPU_HSIOM_PRT7_PRT)
DECLARE_MS_PPU_FX(HSIOM_PRT7_PRT)
#endif

#if (RTE_MS_PPU_HSIOM_PRT8_PRT)
DECLARE_MS_PPU_FX(HSIOM_PRT8_PRT)
#endif

#if (RTE_MS_PPU_HSIOM_PRT9_PRT)
DECLARE_MS_PPU_FX(HSIOM_PRT9_PRT)
#endif

#if (RTE_MS_PPU_HSIOM_PRT10_PRT)
DECLARE_MS_PPU_FX(HSIOM_PRT10_PRT)
#endif

#if (RTE_MS_PPU_HSIOM_PRT11_PRT)
DECLARE_MS_PPU_FX(HSIOM_PRT11_PRT)
#endif

#if (RTE_MS_PPU_HSIOM_PRT12_PRT)
DECLARE_MS_PPU_FX(HSIOM_PRT12_PRT)
#endif

#if (RTE_MS_PPU_HSIOM_PRT13_PRT)
DECLARE_MS_PPU_FX(HSIOM_PRT13_PRT)
#endif

#if (RTE_MS_PPU_HSIOM_PRT14_PRT)
DECLARE_MS_PPU_FX(HSIOM_PRT14_PRT)
#endif

#if (RTE_MS_PPU_HSIOM_AMUX)
DECLARE_MS_PPU_FX(HSIOM_AMUX)
#endif

#if (RTE_MS_PPU_HSIOM_MON)
DECLARE_MS_PPU_FX(HSIOM_MON)
#endif

#if (RTE_MS_PPU_GPIO_PRT0_PRT)
DECLARE_MS_PPU_FX(GPIO_PRT0_PRT)
#endif

#if (RTE_MS_PPU_GPIO_PRT1_PRT)
DECLARE_MS_PPU_FX(GPIO_PRT1_PRT)
#endif

#if (RTE_MS_PPU_GPIO_PRT2_PRT)
DECLARE_MS_PPU_FX(GPIO_PRT2_PRT)
#endif

#if (RTE_MS_PPU_GPIO_PRT3_PRT)
DECLARE_MS_PPU_FX(GPIO_PRT3_PRT)
#endif

#if (RTE_MS_PPU_GPIO_PRT4_PRT)
DECLARE_MS_PPU_FX(GPIO_PRT4_PRT)
#endif

#if (RTE_MS_PPU_GPIO_PRT5_PRT)
DECLARE_MS_PPU_FX(GPIO_PRT5_PRT)
#endif

#if (RTE_MS_PPU_GPIO_PRT6_PRT)
DECLARE_MS_PPU_FX(GPIO_PRT6_PRT)
#endif

#if (RTE_MS_PPU_GPIO_PRT7_PRT)
DECLARE_MS_PPU_FX(GPIO_PRT7_PRT)
#endif

#if (RTE_MS_PPU_GPIO_PRT8_PRT)
DECLARE_MS_PPU_FX(GPIO_PRT8_PRT)
#endif

#if (RTE_MS_PPU_GPIO_PRT9_PRT)
DECLARE_MS_PPU_FX(GPIO_PRT9_PRT)
#endif

#if (RTE_MS_PPU_GPIO_PRT10_PRT)
DECLARE_MS_PPU_FX(GPIO_PRT10_PRT)
#endif

#if (RTE_MS_PPU_GPIO_PRT11_PRT)
DECLARE_MS_PPU_FX(GPIO_PRT11_PRT)
#endif

#if (RTE_MS_PPU_GPIO_PRT12_PRT)
DECLARE_MS_PPU_FX(GPIO_PRT12_PRT)
#endif

#if (RTE_MS_PPU_GPIO_PRT13_PRT)
DECLARE_MS_PPU_FX(GPIO_PRT13_PRT)
#endif

#if (RTE_MS_PPU_GPIO_PRT14_PRT)
DECLARE_MS_PPU_FX(GPIO_PRT14_PRT)
#endif

#if (RTE_MS_PPU_GPIO_PRT0_CFG)
DECLARE_MS_PPU_FX(GPIO_PRT0_CFG)
#endif

#if (RTE_MS_PPU_GPIO_PRT1_CFG)
DECLARE_MS_PPU_FX(GPIO_PRT1_CFG)
#endif

#if (RTE_MS_PPU_GPIO_PRT2_CFG)
DECLARE_MS_PPU_FX(GPIO_PRT2_CFG)
#endif

#if (RTE_MS_PPU_GPIO_PRT3_CFG)
DECLARE_MS_PPU_FX(GPIO_PRT3_CFG)
#endif

#if (RTE_MS_PPU_GPIO_PRT4_CFG)
DECLARE_MS_PPU_FX(GPIO_PRT4_CFG)
#endif

#if (RTE_MS_PPU_GPIO_PRT5_CFG)
DECLARE_MS_PPU_FX(GPIO_PRT5_CFG)
#endif

#if (RTE_MS_PPU_GPIO_PRT6_CFG)
DECLARE_MS_PPU_FX(GPIO_PRT6_CFG)
#endif

#if (RTE_MS_PPU_GPIO_PRT7_CFG)
DECLARE_MS_PPU_FX(GPIO_PRT7_CFG)
#endif

#if (RTE_MS_PPU_GPIO_PRT8_CFG)
DECLARE_MS_PPU_FX(GPIO_PRT8_CFG)
#endif

#if (RTE_MS_PPU_GPIO_PRT9_CFG)
DECLARE_MS_PPU_FX(GPIO_PRT9_CFG)
#endif

#if (RTE_MS_PPU_GPIO_PRT10_CFG)
DECLARE_MS_PPU_FX(GPIO_PRT10_CFG)
#endif

#if (RTE_MS_PPU_GPIO_PRT11_CFG)
DECLARE_MS_PPU_FX(GPIO_PRT11_CFG)
#endif

#if (RTE_MS_PPU_GPIO_PRT12_CFG)
DECLARE_MS_PPU_FX(GPIO_PRT12_CFG)
#endif

#if (RTE_MS_PPU_GPIO_PRT13_CFG)
DECLARE_MS_PPU_FX(GPIO_PRT13_CFG)
#endif

#if (RTE_MS_PPU_GPIO_PRT14_CFG)
DECLARE_MS_PPU_FX(GPIO_PRT14_CFG)
#endif

#if (RTE_MS_PPU_GPIO_GPIO)
DECLARE_MS_PPU_FX(GPIO_GPIO)
#endif

#if (RTE_MS_PPU_SMARTIO_PRT8_PRT)
DECLARE_MS_PPU_FX(SMARTIO_PRT8_PRT)
#endif

#if (RTE_MS_PPU_SMARTIO_PRT9_PRT)
DECLARE_MS_PPU_FX(SMARTIO_PRT9_PRT)
#endif

#if (RTE_MS_PPU_LPCOMP)
DECLARE_MS_PPU_FX(LPCOMP)
#endif

#if (RTE_MS_PPU_CSD0)
DECLARE_MS_PPU_FX(CSD0)
#endif

#if (RTE_MS_PPU_TCPWM0)
DECLARE_MS_PPU_FX(TCPWM0)
#endif

#if (RTE_MS_PPU_TCPWM1)
DECLARE_MS_PPU_FX(TCPWM1)
#endif

#if (RTE_MS_PPU_LCD0)
DECLARE_MS_PPU_FX(LCD0)
#endif

#if (RTE_MS_PPU_USBFS0)
DECLARE_MS_PPU_FX(USBFS0)
#endif

#if (RTE_MS_PPU_SMIF0)
DECLARE_MS_PPU_FX(SMIF0)
#endif

#if (RTE_MS_PPU_SDHC0)
DECLARE_MS_PPU_FX(SDHC0)
#endif

#if (RTE_MS_PPU_SDHC1)
DECLARE_MS_PPU_FX(SDHC1)
#endif

#if (RTE_MS_PPU_SCB0)
DECLARE_MS_PPU_FX(SCB0)
#endif

#if (RTE_MS_PPU_SCB1)
DECLARE_MS_PPU_FX(SCB1)
#endif

#if (RTE_MS_PPU_SCB2)
DECLARE_MS_PPU_FX(SCB2)
#endif

#if (RTE_MS_PPU_SCB3)
DECLARE_MS_PPU_FX(SCB3)
#endif

#if (RTE_MS_PPU_SCB4)
DECLARE_MS_PPU_FX(SCB4)
#endif

#if (RTE_MS_PPU_SCB5)
DECLARE_MS_PPU_FX(SCB5)
#endif

#if (RTE_MS_PPU_SCB6)
DECLARE_MS_PPU_FX(SCB6)
#endif

#if (RTE_MS_PPU_SCB7)
DECLARE_MS_PPU_FX(SCB7)
#endif

#if (RTE_MS_PPU_SCB8)
DECLARE_MS_PPU_FX(SCB8)
#endif

#if (RTE_MS_PPU_SCB9)
DECLARE_MS_PPU_FX(SCB9)
#endif

#if (RTE_MS_PPU_SCB10)
DECLARE_MS_PPU_FX(SCB10)
#endif

#if (RTE_MS_PPU_SCB11)
DECLARE_MS_PPU_FX(SCB11)
#endif

#if (RTE_MS_PPU_SCB12)
DECLARE_MS_PPU_FX(SCB12)
#endif

#if (RTE_MS_PPU_PDM0)
DECLARE_MS_PPU_FX(PDM0)
#endif

#if (RTE_MS_PPU_I2S0)
DECLARE_MS_PPU_FX(I2S0)
#endif

#if (RTE_MS_PPU_I2S1)
DECLARE_MS_PPU_FX(I2S1)
#endif

#endif /* __DRIVER_PPU_H__ */
