/*
 * Copyright (c) 2018-2019 Arm Limited. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __RTE_DEVICE_H__
#define __RTE_DEVICE_H__

// <e> MPC (Memory Protection Controller) [Driver_ISRAM0_MPC]
// <i> Configuration settings for Driver_ISRAM0_MPC in component ::Drivers:MPC
#define   RTE_ISRAM0_MPC                  1
// </e> MPC (Memory Protection Controller) [Driver_ISRAM0_MPC]

// <e> MPC (Memory Protection Controller) [Driver_ISRAM1_MPC]
// <i> Configuration settings for Driver_SRAM1_MPC in component ::Drivers:MPC
#define   RTE_ISRAM1_MPC                  1
// </e> MPC (Memory Protection Controller) [Driver_ISRAM1_MPC]

// <e> MPC (Memory Protection Controller) [Driver_ISRAM2_MPC]
// <i> Configuration settings for Driver_ISRAM2_MPC in component ::Drivers:MPC
#define   RTE_ISRAM2_MPC                  1
// </e> MPC (Memory Protection Controller) [Driver_ISRAM2_MPC]

// <e> MPC (Memory Protection Controller) [Driver_ISRAM3_MPC]
// <i> Configuration settings for Driver_SRAM2_MPC in component ::Drivers:MPC
#define   RTE_ISRAM3_MPC                  1
// </e> MPC (Memory Protection Controller) [Driver_SRAM3_MPC]

// <e> MPC (Memory Protection Controller) [Driver_CODE_SRAM_MPC]
// <i> Configuration settings for Driver_CODE_SRAM_MPC in component ::Drivers:MPC
#define   RTE_CODE_SRAM_MPC               1
// </e> MPC (Memory Protection Controller) [Driver_CODE_SRAM_MPC]

// <e> MPC (Memory Protection Controller) [Driver_MRAM_MPC]
// <i> Configuration settings for Driver_MRAM_MPC in component ::Drivers:MPC
#define   RTE_MRAM_MPC                    1
// </e> MPC (Memory Protection Controller) [Driver_MRAM_MPC]

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART0]
// <i> Configuration settings for Driver_USART0 in component ::Drivers:USART
#define   RTE_USART0                      0
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART0]

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART1]
// <i> Configuration settings for Driver_USART1 in component ::Drivers:USART
#define   RTE_USART1                      1
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART1]

// <e> PPC (Peripheral Protection Controller) [Driver_AHB_PPC0]
// <i> Configuration settings for Driver_AHB_PPC0 in component ::Drivers:PPC
#define   RTE_AHB_PPC0                    1
// </e> PPC (Peripheral Protection Controller) [Driver_AHB_PPC0]

// <e> PPC (Peripheral Protection Controller) [Driver_AHB_PPCEXP0]
// <i> Configuration settings for Driver_AHB_PPCEXP0 in component ::Drivers:PPC
#define   RTE_AHB_PPCEXP0                 1
// </e> PPC (Peripheral Protection Controller) [Driver_AHB_PPCEXP0]

// <e> PPC (Peripheral Protection Controller) [Driver_APB_PPC0]
// <i> Configuration settings for Driver_APB_PPC0 in component ::Drivers:PPC
#define   RTE_APB_PPC0                    1
// </e> PPC (Peripheral Protection Controller) [Driver_APB_PPC0]

// <e> PPC (Peripheral Protection Controller) [Driver_APB_PPC1]
// <i> Configuration settings for Driver_APB_PPC1 in component ::Drivers:PPC
#define   RTE_APB_PPC1                    1
// </e> PPC (Peripheral Protection Controller) [Driver_APB_PPC1]

// <e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP0]
// <i> Configuration settings for Driver_APB_PPCEXP0 in component ::Drivers:PPC
#define   RTE_APB_PPCEXP0                 1
// </e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP0]

// <e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP1]
// <i> Configuration settings for Driver_APB_PPCEXP1 in component ::Drivers:PPC
#define   RTE_APB_PPCEXP1                 1
// </e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP1]

// <e> FLASH (Flash Memory) [Driver_FLASH0]
// <i> Configuration settings for Driver_FLASH0 in component ::Drivers:FLASH
#define   RTE_FLASH0                 1
// </e> FLASH (Flash Memory) [Driver_FLASH0]

#endif  /* __RTE_DEVICE_H__ */
