/*
 * Copyright (c) 2016-2019 Arm Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//-------- <<< Use Configuration Wizard in Context Menu >>> --------------------

#ifndef __RTE_DEVICE_H
#define __RTE_DEVICE_H

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART0]
// <i> Configuration settings for Driver_USART0 in component ::Drivers:USART
#define   RTE_USART0                     1
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART0]

// <e> FLASH (Flash Memory) [Driver_FLASH0]
// <i> Configuration settings for Driver_FLASH0 in component ::Drivers:FLASH
#define   RTE_FLASH0                     1
// </e> FLASH (Flash Memory) [Driver_FLASH0]

// <e> MPC (Memory Protection Controller) [Driver_ISRAM0_MPC]
// <i> Configuration settings for Driver_ISRAM0_MPC in component ::Drivers:MPC
#define   RTE_ISRAM0_MPC                 0
// </e> MPC (Memory Protection Controller) [Driver_ISRAM0_MPC]

// <e> MPC (Memory Protection Controller) [Driver_ISRAM1_MPC]
// <i> Configuration settings for Driver_ISRAM1_MPC in component ::Drivers:MPC
#define   RTE_ISRAM1_MPC                 0
// </e> MPC (Memory Protection Controller) [Driver_ISRAM1_MPC]

// <e> MPC (Memory Protection Controller) [Driver_ISRAM2_MPC]
// <i> Configuration settings for Driver_ISRAM2_MPC in component ::Drivers:MPC
#define   RTE_ISRAM2_MPC                 0
// </e> MPC (Memory Protection Controller) [Driver_ISRAM2_MPC]

// <e> MPC (Memory Protection Controller) [Driver_ISRAM3_MPC]
// <i> Configuration settings for Driver_ISRAM3_MPC in component ::Drivers:MPC
#define   RTE_ISRAM3_MPC                 0
// </e> MPC (Memory Protection Controller) [Driver_ISRAM3_MPC]

// <e> MPC (Memory Protection Controller) [Driver_SSRAM1_MPC]
// <i> Configuration settings for Driver_SSRAM1_MPC in component ::Drivers:MPC
#define   RTE_SSRAM1_MPC                 1
// </e> MPC (Memory Protection Controller) [Driver_SSRAM1_MPC]

// <e> MPC (Memory Protection Controller) [Driver_SSRAM2_MPC]
// <i> Configuration settings for Driver_SSRAM2_MPC in component ::Drivers:MPC
#define   RTE_SSRAM2_MPC                 1
// </e> MPC (Memory Protection Controller) [Driver_SSRAM2_MPC]

// <e> MPC (Memory Protection Controller) [Driver_SSRAM3_MPC]
// <i> Configuration settings for Driver_SSRAM3_MPC in component ::Drivers:MPC
#define   RTE_SSRAM3_MPC                 0
// </e> MPC (Memory Protection Controller) [Driver_SSRAM3_MPC]

// <e> PPC (Peripheral Protection Controller) [Driver_AHB_PPCEXP0]
// <i> Configuration settings for Driver_AHB_PPCEXP0 in component ::Drivers:MPC
#define   RTE_AHB_PPCEXP0                0
// </e> PPC (Peripheral Protection Controller) [Driver_AHB_PPCEXP0]

// <e> PPC (Peripheral Protection Controller) [Driver_AHB_PPCEXP1]
// <i> Configuration settings for Driver_AHB_PPCEXP1 in component ::Drivers:MPC
#define   RTE_AHB_PPCEXP1                0
// </e> PPC (Peripheral Protection Controller) [Driver_AHB_PPCEXP1]

// <e> PPC (Peripheral Protection Controller) [Driver_AHB_PPCEXP2]
// <i> Configuration settings for Driver_AHB_PPCEXP2 in component ::Drivers:MPC
#define   RTE_AHB_PPCEXP2                0
// </e> PPC (Peripheral Protection Controller) [Driver_AHB_PPCEXP2]

// <e> PPC (Peripheral Protection Controller) [Driver_AHB_PPCEXP3]
// <i> Configuration settings for Driver_AHB_PPCEXP3 in component ::Drivers:MPC
#define   RTE_AHB_PPCEXP3                0
// </e> PPC (Peripheral Protection Controller) [Driver_AHB_PPCEXP3]

// <e> PPC (Peripheral Protection Controller) [Driver_APB_PPC0]
// <i> Configuration settings for Driver_APB_PPC0 in component ::Drivers:MPC
#define   RTE_APB_PPC0                   0
// </e> PPC (Peripheral Protection Controller) [Driver_APB_PPC0]

// <e> PPC (Peripheral Protection Controller) [Driver_APB_PPC1]
// <i> Configuration settings for Driver_APB_PPC1 in component ::Drivers:MPC
#define   RTE_APB_PPC1                   0
// </e> PPC (Peripheral Protection Controller) [Driver_APB_PPC1]

// <e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP0]
// <i> Configuration settings for Driver_APB_PPCEXP0 in component ::Drivers:MPC
#define   RTE_APB_PPCEXP0                0
// </e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP0]

// <e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP1]
// <i> Configuration settings for Driver_APB_PPCEXP1 in component ::Drivers:MPC
#define   RTE_APB_PPCEXP1                0
// </e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP1]

// <e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP2]
// <i> Configuration settings for Driver_APB_PPCEXP2 in component ::Drivers:MPC
#define   RTE_APB_PPCEXP2                1
// </e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP2]

// <e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP3]
// <i> Configuration settings for Driver_APB_PPCEXP3 in component ::Drivers:MPC
#define   RTE_APB_PPCEXP3                0
// </e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP3]

#endif  /* __RTE_DEVICE_H */
