#!/bin/bash -
#******************************************************************************
#  * @attention
#  *
#  * <h2><center>&copy; Copyright (c) 2019 STMicroelectronics.
#  * All rights reserved.</center></h2>
#  *
#  * This software component is licensed by ST under BSD 3-Clause license,
#  * the "License"; You may not use this file except in compliance with the
#  * License. You may obtain a copy of the License at:
#  *                        opensource.org/licenses/BSD-3-Clause
#  *
#  ******************************************************************************

# Absolute path to this script
SCRIPT=$(readlink -f $0)
# Absolute path this script
projectdir=`dirname $SCRIPT`
# the file to preprocess is generated and present outside of install dir
bl2_file_to_preprocess=$projectdir/../image_macros_to_preprocess_bl2.c
preprocess_bl2_file=$projectdir/../image_macros_preprocessed_bl2.c
regressionsh=$projectdir/regression.sh
updatesh=$projectdir/TFM_UPDATE.sh

basedir=$projectdir
echo preprocess bl2 file
arm-none-eabi-gcc -E -P -xc -I$projectdir -o$preprocess_bl2_file $bl2_file_to_preprocess
imgtool=$basedir"/scripts/imgtool.py"
#determine/check python version command
cmd="python3"
$cmd --version  &> /dev/null
ret=$?
if [ $ret != 0 ]; then
  cmd="python"
  $cmd --version  &> /dev/null
  ret=$?
  if [ $ret != 0 ]; then
    echo "This script requires python 3.0 or greater"
    exit 1
  fi
  ver=$(python -V 2>&1 | sed 's/.* \([0-9]\).\([0-9]\).*/\1\2/')
  if [ "$ver" -lt "30" ]; then
    echo "This script requires python 3.0 or greater"
    exit 1
  fi
fi

command=$cmd" "$imgtool" flash --layout "$preprocess_bl2_file" -b secbootadd0 -m  RE_BL2_BOOT_ADDRESS  -d 0x80  -s 0 "$regressionsh
$command  >> $projectdir"/output.txt"
ret=$?
if [ $ret != 0 ]; then
echo "postbuild.sh failed"
echo $command
exit 1
fi

command=$cmd" "$imgtool" flash --layout "$preprocess_bl2_file" -b boot -m  RE_BL2_PERSO_ADDRESS -s 0 "$updatesh
$command  >> $projectdir"/output.txt"
ret=$?
if [ $ret != 0 ]; then
echo "postbuild.sh failed"
echo $command
exit 1
fi

command=$cmd" "$imgtool" flash --layout "$preprocess_bl2_file" -b slot0 -m  RE_IMAGE_FLASH_ADDRESS_SECURE -s 0 "$updatesh
$command  >> $projectdir"/output.txt"
ret=$?
if [ $ret != 0 ]; then
echo "postbuild.sh failed"
echo $command
exit 1
fi

echo $updatebat" updated"
command=$cmd" "$imgtool" flash --layout "$preprocess_bl2_file" -b slot1 -m  RE_IMAGE_FLASH_ADDRESS_NON_SECURE -s 0 "$updatesh
$command  >> $projectdir"/output.txt"
ret=$?
if [ $ret != 0 ]; then
echo "postbuild.sh failed"
echo $command
exit 1
fi
echo $updatebat" updated"
command=$cmd" "$imgtool" flash --layout "$preprocess_bl2_file" -b slot2 -m  RE_IMAGE_FLASH_SECURE_UPDATE -s 0 "$updatesh
$command  >> $projectdir"/output.txt"
ret=$?
if [ $ret != 0 ]; then
echo "postbuild.sh failed"
echo $command
exit 1
fi
echo $updatebat" updated"
command=$cmd" "$imgtool" flash --layout "$preprocess_bl2_file" -b slot3 -m  RE_IMAGE_FLASH_NON_SECURE_UPDATE -s 0 "$updatesh
$command  >> $projectdir"/output.txt"
ret=$?
if [ $ret != 0 ]; then
echo "postbuild.sh failed"
echo $command
exit 1
fi
echo $updatebat" updated"
command=$cmd" "$imgtool" flash --layout "$preprocess_bl2_file" -b scratch -m  RE_IMAGE_FLASH_SCRATCH -s 0 "$updatesh
$command  >> $projectdir"/output.txt"
ret=$?
if [ $ret != 0 ]; then
echo "postbuild.sh failed"
echo $command
exit 1
fi
echo $updatebat" updated"
command=$cmd" "$imgtool" flash --layout "$preprocess_bl2_file" -b nvcounter -m  RE_IMAGE_FLASH_NV_COUNTERS -s 0 "$updatesh
$command  >> $projectdir"/output.txt"
ret=$?
if [ $ret != 0 ]; then
echo "postbuild.sh failed"
echo $command
exit 1
fi
echo $updatebat" updated"
command=$cmd" "$imgtool" flash --layout "$preprocess_bl2_file" -b sst -m  RE_IMAGE_FLASH_NV_PS -s 0 "$updatesh
$command  >> $projectdir"/output.txt"
ret=$?
if [ $ret != 0 ]; then
echo "postbuild.sh failed"
echo $command
exit 1
fi
echo $updatebat" updated"
command=$cmd" "$imgtool" flash --layout "$preprocess_bl2_file" -b its -m  RE_IMAGE_FLASH_NV_ITS -s 0 "$updatesh
$command  >> $projectdir"/output.txt"
ret=$?
if [ $ret != 0 ]; then
echo "postbuild.sh failed"
echo $command
exit 1
fi
echo $updatebat" updated"
command=$cmd" "$imgtool" flash --layout "$preprocess_bl2_file" -b unused -m  RE_IMAGE_FLASH_UNUSED -s 0 "$updatesh
$command  >> $projectdir"/output.txt"
ret=$?
if [ $ret != 0 ]; then
echo "postbuild.sh failed"
echo $command
exit 1
fi
